/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.yaml.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.hemantsonu20.json.JsonMerge;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import ru.volnenko.maven.plugin.yaml.exception.UnsupportedFormatException;

public final class RootParser {
    @NonNull
    private static final ObjectMapper JSON = new ObjectMapper();
    @NonNull
    private static final ObjectMapper YAML = new YAMLMapper();
    @NonNull
    private List<String> files = Collections.emptyList();

    @NonNull
    public RootParser files(@NonNull List<String> files) {
        if (files == null) {
            throw new NullPointerException("files is marked non-null but is null");
        }
        this.files = files;
        return this;
    }

    @NonNull
    private ObjectMapper objectMapper(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull String name = file.toLowerCase(Locale.ROOT);
        if (name.endsWith(".json")) {
            return JSON;
        }
        if (name.endsWith(".yaml")) {
            return YAML;
        }
        if (name.endsWith(".yml")) {
            return YAML;
        }
        throw new UnsupportedFormatException();
    }

    @NonNull
    private JsonNode map(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull ObjectMapper objectMapper = this.objectMapper(file);
        return objectMapper.readTree(new File(file));
    }

    @NonNull
    public List<JsonNode> all() {
        @NonNull ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        for (String file : this.files) {
            if (file == null || file.isEmpty()) continue;
            result.add(this.map(file));
        }
        return result;
    }

    @NonNull
    public JsonNode jsonNode() {
        @NonNull List<JsonNode> jsonNodes = this.all();
        @NonNull JsonNode mergedNodes = jsonNodes.get(0);
        for (int i = 1; i < jsonNodes.size(); ++i) {
            mergedNodes = JsonMerge.merge((JsonNode)mergedNodes, (JsonNode)jsonNodes.get(i));
        }
        return mergedNodes;
    }

    public String json() {
        return JSON.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.jsonNode());
    }

    public String yaml() {
        return YAML.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.jsonNode());
    }
}

