/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.yaml.goal;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import ru.volnenko.maven.plugin.yaml.parser.RootParser;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class YamlGenerate
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="files")
    private List<String> files = new ArrayList<String>();
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        @NonNull File buildPath = new File(this.project.getBuild().getDirectory());
        buildPath.mkdirs();
        for (Object dependencyObject : this.project.getDependencyArtifacts()) {
            DefaultArtifact dependency;
            if (dependencyObject == null || !"compile".equalsIgnoreCase((dependency = (DefaultArtifact)dependencyObject).getScope()) || !"json".equalsIgnoreCase(dependency.getType()) && !"yaml".equalsIgnoreCase(dependency.getType())) continue;
            String classifier = dependency.getClassifier();
            classifier = classifier == null ? "" : "-" + classifier;
            @NonNull String name = dependency.getGroupId().replace(".", "/") + "/" + dependency.getArtifactId() + "/" + dependency.getVersion() + "/" + dependency.getArtifactId() + "-" + dependency.getVersion() + classifier + "." + dependency.getType();
            @NonNull File file = new File(this.settings.getLocalRepository(), name);
            @NonNull String filename = file.getAbsolutePath();
            if (!file.exists()) {
                this.getLog().error((CharSequence)("Error! File `" + filename + "` is not exists..."));
                continue;
            }
            if (this.files.contains(file.getAbsolutePath())) continue;
            this.files.add(filename);
            this.getLog().info((CharSequence)("ADDED: " + file));
        }
        @NonNull String sourceNameJSON = this.project.getBuild().getFinalName() + "." + this.project.getPackaging();
        @NonNull File build = new File(this.project.getBuild().getDirectory(), sourceNameJSON);
        if (!this.files.isEmpty()) {
            @NonNull RootParser rootParser = new RootParser();
            @NonNull String yaml = rootParser.files(this.files).yaml();
            Files.write(build.toPath(), yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            @NonNull YAMLMapper mapper = new YAMLMapper();
            mapper.writerWithDefaultPrettyPrinter().writeValue(build, Collections.emptyMap());
        }
    }

    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(List<String> files) {
        this.files = files;
    }
}

