/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.hemantsonu20.json.JsonMerge;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.exception.SwaggerSchemeNotSupportedException;
import ru.volnenko.plugin.openapidoc.exception.UnsupportedFormatException;
import ru.volnenko.plugin.openapidoc.model.impl.Root;
import ru.volnenko.plugin.openapidoc.parser.IRootParser;
import ru.volnenko.plugin.openapidoc.util.MapperUtil;

public final class RootParser
implements IRootParser {
    @NonNull
    private List<String> files = Collections.emptyList();

    @NonNull
    public RootParser files(@NonNull List<String> files) {
        if (files == null) {
            throw new NullPointerException("files is marked non-null but is null");
        }
        this.files = files;
        return this;
    }

    @NonNull
    private JsonNode map(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull ObjectMapper objectMapper = this.objectMapper(file);
        return objectMapper.readTree(new File(file));
    }

    @NonNull
    private ObjectMapper objectMapper(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull String name = file.toLowerCase(Locale.ROOT);
        if (name.endsWith(".json")) {
            return MapperUtil.json();
        }
        if (name.endsWith(".yaml")) {
            return MapperUtil.yaml();
        }
        if (name.endsWith(".yml")) {
            return MapperUtil.yaml();
        }
        throw new UnsupportedFormatException();
    }

    @Override
    @NonNull
    public Root parse(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull ObjectMapper objectMapper = this.objectMapper(file);
        @NonNull Root root = (Root)objectMapper.readValue(new File(file), Root.class);
        if (root.getSwagger() != null && !root.getSwagger().isEmpty()) {
            throw new SwaggerSchemeNotSupportedException();
        }
        return root;
    }

    @Override
    @NonNull
    public List<JsonNode> all() {
        @NonNull ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        for (String file : this.files) {
            if (file == null || file.isEmpty()) continue;
            result.add(this.map(file));
        }
        return result;
    }

    @Override
    @NonNull
    public JsonNode jsonNode() {
        @NonNull List<JsonNode> jsonNodes = this.all();
        @NonNull JsonNode mergedNodes = jsonNodes.get(0);
        for (int i = 1; i < jsonNodes.size(); ++i) {
            mergedNodes = JsonMerge.merge((JsonNode)mergedNodes, (JsonNode)jsonNodes.get(i));
        }
        return mergedNodes;
    }

    @Override
    @NonNull
    public String json() {
        return MapperUtil.json().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.jsonNode());
    }

    @Override
    @NonNull
    public String yaml() {
        return MapperUtil.yaml().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.jsonNode());
    }

    @Override
    @NonNull
    public List<Root> parse() {
        @NonNull ArrayList<Root> result = new ArrayList<Root>();
        for (String file : this.files) {
            if (file == null || file.isEmpty()) continue;
            result.add(this.parse(file));
        }
        return result;
    }
}

