/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import java.util.Map;
import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.ISchemaGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Schema;
import ru.volnenko.plugin.openapidoc.util.ContentUtil;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

public final class SchemaGenerator
implements ISchemaGenerator {
    private String model;
    private Schema schema;
    private String serviceName;

    @Override
    @NonNull
    public ISchemaGenerator serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public ISchemaGenerator schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    @Override
    @NonNull
    public ISchemaGenerator model(String model) {
        this.model = model;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("=== \u041c\u043e\u0434\u0435\u043b\u044c \u0434\u0430\u043d\u043d\u044b\u0445 \"" + this.model + "\" [[" + this.model + "]]\n");
        stringBuilder.append("\n");
        stringBuilder.append("==== \u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f\n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"20,80\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.model) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.schema.getDescription()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*:\n");
        stringBuilder.append("|" + StringUtil.format(this.schema.getType()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0421\u0435\u0440\u0432\u0438\u0441*:\n");
        stringBuilder.append("|" + StringUtil.format(this.serviceName) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0435\u0439 \n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"0,20,20,20,20,10,10\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("^|*\u2116*\n");
        stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("|*\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        stringBuilder.append("\n");
        boolean exists = true;
        Map<String, Schema> properties = this.schema.getProperties();
        if ("array".equalsIgnoreCase(this.schema.getType()) && this.schema.getItems() != null) {
            properties = this.schema.getItems().getProperties();
        }
        if (properties == null) {
            exists = false;
        }
        if (properties != null && properties.isEmpty()) {
            exists = false;
        }
        if (!exists) {
            stringBuilder.append("\n");
            stringBuilder.append("7+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            stringBuilder.append("\n");
        }
        if (exists) {
            int index = 1;
            for (String field : properties.keySet()) {
                Schema property = properties.get(field);
                stringBuilder.append("\n");
                stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
                stringBuilder.append("|" + StringUtil.format(field) + "\n");
                stringBuilder.append("|" + StringUtil.format(property.getTitle()) + "\n");
                stringBuilder.append("|" + StringUtil.format(property.getDescription()) + "\n");
                stringBuilder.append("^| " + ContentUtil.scheme(property) + "\n");
                stringBuilder.append("^|" + ContentUtil.format(property) + "\n");
                if (this.schema.getRequired() == null) {
                    stringBuilder.append("^|--\n");
                } else if (this.schema.getRequired().contains(field)) {
                    stringBuilder.append("^|\u2713\n");
                } else {
                    stringBuilder.append("^|--\n");
                }
                ++index;
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        return stringBuilder;
    }
}

