/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.IResponseGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Content;
import ru.volnenko.plugin.openapidoc.model.impl.Response;
import ru.volnenko.plugin.openapidoc.util.ContentUtil;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

public final class ResponseGenerator
implements IResponseGenerator {
    @NonNull
    private String httpCode = "";
    @NonNull
    private Response response = new Response();
    private int index = 0;

    @Override
    public int index() {
        return this.index;
    }

    @Override
    @NonNull
    public Response response() {
        return this.response;
    }

    @Override
    @NonNull
    public String httpCode() {
        return this.httpCode;
    }

    @Override
    @NonNull
    public IResponseGenerator index(int index) {
        this.index = index;
        return this;
    }

    @Override
    @NonNull
    public IResponseGenerator httpCode(@NonNull String httpCode) {
        if (httpCode == null) {
            throw new NullPointerException("httpCode is marked non-null but is null");
        }
        this.httpCode = httpCode;
        return this;
    }

    @Override
    @NonNull
    public IResponseGenerator response(@NonNull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (this.response.getContent() == null || this.response.getContent().isEmpty()) {
            return stringBuilder;
        }
        for (String mediaType : this.response.getContent().keySet()) {
            Content content = this.response.getContent().get(mediaType);
            stringBuilder.append("\n");
            stringBuilder.append("^|" + StringUtil.format(this.index) + ". \n");
            stringBuilder.append("^|" + StringUtil.format(this.httpCode) + "\n");
            stringBuilder.append("^| \"" + StringUtil.format(mediaType) + "\" \n");
            stringBuilder.append("|" + String.format(this.response.getDescription(), new Object[0]) + "\n");
            stringBuilder.append("^| " + ContentUtil.scheme(content) + "\n");
            stringBuilder.append("^|" + ContentUtil.format(content) + "\n");
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }
}

