/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.IParameterGenerator;
import ru.volnenko.plugin.openapidoc.generator.IParametersGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.ParameterGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Parameter;

public final class ParametersGenerator
implements IParametersGenerator {
    @NonNull
    private List<Parameter> parameters = Collections.emptyList();
    @NonNull
    private final IParameterGenerator parameterGenerator = new ParameterGenerator();

    @Override
    @NonNull
    public IParametersGenerator parameters(@NonNull List<Parameter> parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.parameters = parameters;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \n");
        int index = 1;
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"0,20,20,10,10,10,10\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("^|*\u2116*\n");
        stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("^|*\u0422\u0438\u043f*\n");
        stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        stringBuilder.append("^|*\u0412\u0438\u0434*\n");
        stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        stringBuilder.append("\n");
        if (this.parameters.size() == 0) {
            stringBuilder.append("\n");
            stringBuilder.append("7+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            stringBuilder.append("\n");
        }
        for (Parameter parameter : this.parameters) {
            this.generate(stringBuilder, parameter, index);
            ++index;
        }
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        return stringBuilder;
    }

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull Parameter parameter, int index) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameterGenerator.index(index).parameter(parameter).append(stringBuilder);
    }
}

