/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.IOperationGenerator;
import ru.volnenko.plugin.openapidoc.generator.IParametersGenerator;
import ru.volnenko.plugin.openapidoc.generator.IResponseGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.ParametersGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.ResponseGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Content;
import ru.volnenko.plugin.openapidoc.model.impl.Operation;
import ru.volnenko.plugin.openapidoc.model.impl.Parameter;
import ru.volnenko.plugin.openapidoc.model.impl.Response;
import ru.volnenko.plugin.openapidoc.util.ContentUtil;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

public final class OperationGenerator
implements IOperationGenerator {
    @NonNull
    private final IParametersGenerator parametersGenerator = new ParametersGenerator();
    @NonNull
    private final IResponseGenerator responseGenerator = new ResponseGenerator();
    private Operation operation;
    private String path;
    private String method;
    private String serviceName;

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    @NonNull
    public IOperationGenerator path(String path) {
        this.path = path;
        return this;
    }

    @Override
    @NonNull
    public IOperationGenerator method(String method) {
        this.method = method;
        return this;
    }

    @Override
    @NonNull
    public IOperationGenerator serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public Operation operation() {
        return this.operation;
    }

    @Override
    @NonNull
    public IOperationGenerator operation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operation = operation;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (this.path == null || this.path.isEmpty()) {
            return stringBuilder;
        }
        if (this.method == null || this.method.isEmpty()) {
            return stringBuilder;
        }
        if (this.operation == null) {
            return stringBuilder;
        }
        stringBuilder.append("=== \u0420\u0435\u0441\u0443\u0440\u0441 " + this.operation.tags() + " " + this.method.toUpperCase() + " \"" + this.path + "\" \n");
        stringBuilder.append("==== \u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f\n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"20,80\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.operation.getOperationId()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.operation.getSummary()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0421\u0435\u0440\u0432\u0438\u0441*:\n");
        stringBuilder.append("|" + StringUtil.format(this.serviceName) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*HTTP-\u043c\u0435\u0442\u043e\u0434*:\n");
        stringBuilder.append("|" + StringUtil.format(this.method.toUpperCase()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*HTTP-\u0430\u0434\u0440\u0435\u0441*:\n");
        stringBuilder.append("|" + StringUtil.format(this.path) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        if (this.operation.getParameters() == null) {
            this.operation.setParameters(Collections.emptyList());
        }
        this.generate(stringBuilder, this.operation.getParameters());
        stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"0,20,50,20,10\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("^|*\u2116*\n");
        stringBuilder.append("^|*\u041c\u0435\u0434\u0438\u0430 \u0442\u0438\u043f*\n");
        stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        stringBuilder.append("\n");
        boolean exists = true;
        if (this.operation.getRequestBody() == null) {
            exists = false;
        }
        if (this.operation.getRequestBody() != null) {
            if (this.operation.getRequestBody().getContent() == null) {
                exists = false;
            } else if (this.operation.getRequestBody().getContent().isEmpty()) {
                exists = false;
            }
        }
        if (!exists) {
            stringBuilder.append("\n");
            stringBuilder.append("5+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            stringBuilder.append("\n");
        }
        if (this.operation.getRequestBody() != null && this.operation.getRequestBody().getContent() != null) {
            int index = 1;
            for (String mediaType : this.operation.getRequestBody().getContent().keySet()) {
                Content content = this.operation.getRequestBody().getContent().get(mediaType);
                if (content == null) continue;
                stringBuilder.append("\n");
                stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
                stringBuilder.append("^|" + StringUtil.format(mediaType) + "\n");
                stringBuilder.append("^| " + ContentUtil.scheme(content) + "\n");
                stringBuilder.append("^|" + ContentUtil.format(content) + "\n");
                stringBuilder.append("^|" + StringUtil.format(this.operation.getRequestBody().getRequired()) + "\n");
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        this.generate(stringBuilder, this.operation);
        return stringBuilder;
    }

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull Operation operation) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"0,15,20,50,30,20\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("^|*\u2116*\n");
        stringBuilder.append("^|*HTTP-\u043a\u043e\u0434*\n");
        stringBuilder.append("^|*\u041c\u0435\u0434\u0438\u0430 \u0442\u0438\u043f*\n");
        stringBuilder.append("|*\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435*\n");
        stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        stringBuilder.append("\n");
        if (operation.getResponses() == null) {
            operation.setResponses(Collections.emptyMap());
        }
        int index = 1;
        for (String httpCode : operation.getResponses().keySet()) {
            Response response = operation.getResponses().get(httpCode);
            if (response.getContent() == null || response.getContent().isEmpty()) continue;
            this.generate(stringBuilder, httpCode, response, index);
            ++index;
        }
        if (index == 1) {
            stringBuilder.append("\n");
            stringBuilder.append("6+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
    }

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull String httpCode, @NonNull Response response, int index) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (httpCode == null) {
            throw new NullPointerException("httpCode is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.responseGenerator.response(response).httpCode(httpCode).index(index).append(stringBuilder);
    }

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull List<Parameter> parameters) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.parametersGenerator.parameters(parameters).append(stringBuilder);
    }
}

