/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.IHeaderGenerator;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

public final class HeaderGenerator
implements IHeaderGenerator {
    public boolean headerFirstEnabled = true;
    public boolean tableOfContentsEnabled = true;
    public boolean headerSecondEnabled = true;
    @NonNull
    public String headerFirstText = "";

    @Override
    @NonNull
    public String headerFirstText() {
        return this.headerFirstText;
    }

    @Override
    public boolean headerSecondEnabled() {
        return this.headerSecondEnabled;
    }

    @Override
    public boolean tableOfContentsEnabled() {
        return this.tableOfContentsEnabled;
    }

    @Override
    public boolean headerFirstEnabled() {
        return this.headerFirstEnabled;
    }

    @Override
    @NonNull
    public IHeaderGenerator headerFirstEnabled(boolean headerFirstEnabled) {
        this.headerFirstEnabled = headerFirstEnabled;
        return this;
    }

    @Override
    @NonNull
    public IHeaderGenerator headerSecondEnabled(boolean headerSecondEnabled) {
        this.headerSecondEnabled = headerSecondEnabled;
        return this;
    }

    @Override
    @NonNull
    public IHeaderGenerator tableOfContentsEnabled(boolean tableOfContentsEnabled) {
        this.tableOfContentsEnabled = tableOfContentsEnabled;
        return this;
    }

    @Override
    @NonNull
    public IHeaderGenerator headerFirstText(@NonNull String headerFirstText) {
        if (headerFirstText == null) {
            throw new NullPointerException("headerFirstText is marked non-null but is null");
        }
        this.headerFirstText = headerFirstText;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (this.headerFirstEnabled) {
            stringBuilder.append("= " + StringUtil.format(this.headerFirstText) + "\n");
            if (this.tableOfContentsEnabled) {
                stringBuilder.append(":toc-title: \u041e\u0433\u043b\u0430\u0432\u043b\u0435\u043d\u0438\u0435\n");
                stringBuilder.append(":toc:\n");
            }
            stringBuilder.append("\n");
        }
        if (this.headerSecondEnabled) {
            stringBuilder.append("== \u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0431-\u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \n");
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }
}

