/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.plugin.openapidoc.generator.IComponentsGenerator;
import ru.volnenko.plugin.openapidoc.generator.ISchemaGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.SchemaGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Components;
import ru.volnenko.plugin.openapidoc.model.impl.Schema;

public final class ComponentsGenerator
implements IComponentsGenerator {
    @NonNull
    private final ISchemaGenerator schemaGenerator = new SchemaGenerator();
    private Components components;
    private String serviceName;

    @Override
    @NonNull
    public IComponentsGenerator components(Components components) {
        this.components = components;
        return this;
    }

    @Override
    @NonNull
    public IComponentsGenerator serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    private void generate(@NonNull StringBuilder stringBuilder, String model, String serviceName, Schema schema) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        this.schemaGenerator.model(model).schema(schema).serviceName(serviceName).append(stringBuilder);
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (this.components == null) {
            return stringBuilder;
        }
        if (this.components.getSchemas() == null) {
            return stringBuilder;
        }
        if (this.components.getSchemas().isEmpty()) {
            return stringBuilder;
        }
        for (String model : this.components.getSchemas().keySet()) {
            this.generate(stringBuilder, model, this.serviceName, this.components.getSchemas().get(model));
        }
        return stringBuilder;
    }
}

