/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import ru.volnenko.plugin.openapidoc.exception.UnsupportedFormatException;
import ru.volnenko.plugin.openapidoc.generator.IComponentsGenerator;
import ru.volnenko.plugin.openapidoc.generator.IHeaderGenerator;
import ru.volnenko.plugin.openapidoc.generator.IOperationGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.ComponentsGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.HeaderGenerator;
import ru.volnenko.plugin.openapidoc.generator.impl.OperationGenerator;
import ru.volnenko.plugin.openapidoc.model.impl.Components;
import ru.volnenko.plugin.openapidoc.model.impl.Operation;
import ru.volnenko.plugin.openapidoc.model.impl.Root;
import ru.volnenko.plugin.openapidoc.parser.RootParser;
import ru.volnenko.plugin.openapidoc.util.MapperUtil;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public final class Generator
extends AbstractMojo {
    @Parameter(property="serviceName")
    public String serviceName = "\u0421\u0435\u0440\u0432\u0438\u0441";
    @Parameter(property="headerFirstText")
    private String headerFirstText = "REST API";
    @Parameter(property="headerFirstEnabled")
    public boolean headerFirstEnabled = true;
    @Parameter(property="headerSecondEnabled")
    public boolean headerSecondEnabled = true;
    @Parameter(property="tableOfContentsEnabled")
    public boolean tableOfContentsEnabled = true;
    @Parameter(property="outputPath")
    public String outputPath = "./doc";
    @Parameter(property="outputFile")
    public String outputFile = "index.adoc";
    @Parameter(property="outputJsonFile")
    public String outputJsonFile = "scheme.json";
    @Parameter(property="outputJsonFileEnabled")
    public Boolean outputJsonFileEnabled = false;
    @Parameter(property="outputJavaScriptFile")
    public String outputJavaScriptFile = "scheme.js";
    @Parameter(property="outputJavaScriptFileEnabled")
    public Boolean outputJavaScriptFileEnabled = false;
    @Parameter(property="outputYamlFile")
    public String outputYamlFile = "scheme.yaml";
    @Parameter(property="outputYamlFileEnabled")
    public Boolean outputYamlFileEnabled = false;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="files")
    private List<String> files = new ArrayList<String>();
    @NonNull
    private final RootParser rootParser = new RootParser();
    @NonNull
    private final StringBuilder stringBuilder = new StringBuilder();
    @NonNull
    private final IHeaderGenerator rootGenerator = new HeaderGenerator();
    @NonNull
    private final IOperationGenerator operationGenerator = new OperationGenerator();
    @NonNull
    private final IComponentsGenerator componentsGenerator = new ComponentsGenerator();

    @NonNull
    private ObjectMapper objectMapper(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull String name = file.toLowerCase(Locale.ROOT);
        if (name.endsWith(".json")) {
            return MapperUtil.json();
        }
        if (name.endsWith(".yaml")) {
            return MapperUtil.yaml();
        }
        if (name.endsWith(".yml")) {
            return MapperUtil.yaml();
        }
        throw new UnsupportedFormatException();
    }

    public void execute() {
        this.header();
        @NonNull String json = this.rootParser.files(this.files).json();
        @NonNull Root root = (Root)MapperUtil.json().readValue(json, Root.class);
        this.generate(root);
        this.save();
    }

    @NonNull
    private Generator saveDatabaseYAML(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputYamlFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputYamlFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputYamlFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)this.rootParser.yaml());
        return this;
    }

    @NonNull
    private Generator saveDatabaseJSON(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputJsonFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputJsonFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputJsonFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)this.rootParser.json());
        return this;
    }

    @NonNull
    private Generator saveDatabaseJavaScript(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputJavaScriptFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputJavaScriptFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputJavaScriptFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)("var scheme = " + this.rootParser.json()));
        return this;
    }

    public void save() {
        if (this.outputPath == null || this.outputPath.isEmpty()) {
            return;
        }
        if (this.outputFile == null || this.outputFile.isEmpty()) {
            return;
        }
        @NonNull File path = new File(this.outputPath);
        this.initOutputPath(path).saveDatabaseYAML(path).saveDatabaseJSON(path).saveDatabaseJavaScript(path);
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputFile);
        FileUtils.fileWrite((File)file, (String)this.stringBuilder.toString());
    }

    @NonNull
    private Generator initOutputPath(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        path.mkdirs();
        return this;
    }

    public void parse(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull ObjectMapper objectMapper = this.objectMapper(file);
        @NonNull Root root = (Root)objectMapper.readValue(new File(file), Root.class);
        this.generate(root);
    }

    @NonNull
    public String generate(Root root) {
        if (root == null) {
            return "";
        }
        this.generate(root.getPaths());
        this.generate(root.getComponents());
        return this.stringBuilder.toString();
    }

    private void generate(Map<String, Map<String, Operation>> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (String path : paths.keySet()) {
            if (path == null || path.isEmpty()) continue;
            this.generate(path, paths.get(path));
        }
    }

    private void generate(String path, Map<String, Operation> operations) {
        if (path == null) {
            return;
        }
        for (String method : operations.keySet()) {
            if (method == null || method.isEmpty()) continue;
            this.generate(path, method, operations.get(method));
        }
    }

    private void generate(Components components) {
        this.componentsGenerator.serviceName(this.serviceName).components(components).append(this.stringBuilder);
    }

    private void generate(String path, String method, Operation operation) {
        this.operationGenerator.path(path).method(method).operation(operation).serviceName(this.serviceName).append(this.stringBuilder);
    }

    private void header() {
        this.rootGenerator.headerFirstText(this.headerFirstText).headerFirstEnabled(this.headerFirstEnabled).headerSecondEnabled(this.headerSecondEnabled).tableOfContentsEnabled(this.tableOfContentsEnabled).append(this.stringBuilder);
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getHeaderFirstText() {
        return this.headerFirstText;
    }

    @Generated
    public void setHeaderFirstText(String headerFirstText) {
        this.headerFirstText = headerFirstText;
    }

    @Generated
    public boolean isHeaderFirstEnabled() {
        return this.headerFirstEnabled;
    }

    @Generated
    public void setHeaderFirstEnabled(boolean headerFirstEnabled) {
        this.headerFirstEnabled = headerFirstEnabled;
    }

    @Generated
    public boolean isHeaderSecondEnabled() {
        return this.headerSecondEnabled;
    }

    @Generated
    public void setHeaderSecondEnabled(boolean headerSecondEnabled) {
        this.headerSecondEnabled = headerSecondEnabled;
    }

    @Generated
    public boolean isTableOfContentsEnabled() {
        return this.tableOfContentsEnabled;
    }

    @Generated
    public void setTableOfContentsEnabled(boolean tableOfContentsEnabled) {
        this.tableOfContentsEnabled = tableOfContentsEnabled;
    }

    @Generated
    public String getOutputPath() {
        return this.outputPath;
    }

    @Generated
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Generated
    public String getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Generated
    public String getOutputJsonFile() {
        return this.outputJsonFile;
    }

    @Generated
    public void setOutputJsonFile(String outputJsonFile) {
        this.outputJsonFile = outputJsonFile;
    }

    @Generated
    public Boolean getOutputJsonFileEnabled() {
        return this.outputJsonFileEnabled;
    }

    @Generated
    public void setOutputJsonFileEnabled(Boolean outputJsonFileEnabled) {
        this.outputJsonFileEnabled = outputJsonFileEnabled;
    }

    @Generated
    public String getOutputJavaScriptFile() {
        return this.outputJavaScriptFile;
    }

    @Generated
    public void setOutputJavaScriptFile(String outputJavaScriptFile) {
        this.outputJavaScriptFile = outputJavaScriptFile;
    }

    @Generated
    public Boolean getOutputJavaScriptFileEnabled() {
        return this.outputJavaScriptFileEnabled;
    }

    @Generated
    public void setOutputJavaScriptFileEnabled(Boolean outputJavaScriptFileEnabled) {
        this.outputJavaScriptFileEnabled = outputJavaScriptFileEnabled;
    }

    @Generated
    public String getOutputYamlFile() {
        return this.outputYamlFile;
    }

    @Generated
    public void setOutputYamlFile(String outputYamlFile) {
        this.outputYamlFile = outputYamlFile;
    }

    @Generated
    public Boolean getOutputYamlFileEnabled() {
        return this.outputYamlFileEnabled;
    }

    @Generated
    public void setOutputYamlFileEnabled(Boolean outputYamlFileEnabled) {
        this.outputYamlFileEnabled = outputYamlFileEnabled;
    }

    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(List<String> files) {
        this.files = files;
    }

    @NonNull
    @Generated
    public RootParser getRootParser() {
        return this.rootParser;
    }
}

