/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import ru.volnenko.plugin.openapidoc.exception.UnsupportedFormatException;
import ru.volnenko.plugin.openapidoc.model.Components;
import ru.volnenko.plugin.openapidoc.model.Content;
import ru.volnenko.plugin.openapidoc.model.Operation;
import ru.volnenko.plugin.openapidoc.model.Parameter;
import ru.volnenko.plugin.openapidoc.model.Response;
import ru.volnenko.plugin.openapidoc.model.Root;
import ru.volnenko.plugin.openapidoc.model.Schema;
import ru.volnenko.plugin.openapidoc.parser.RootParser;
import ru.volnenko.plugin.openapidoc.util.ContentUtil;
import ru.volnenko.plugin.openapidoc.util.MapperUtil;
import ru.volnenko.plugin.openapidoc.util.ParameterUtil;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public final class Generator
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(property="serviceName")
    public String serviceName = "\u0421\u0435\u0440\u0432\u0438\u0441";
    @org.apache.maven.plugins.annotations.Parameter(property="headerFirstEnabled")
    public boolean headerFirstEnabled = true;
    @org.apache.maven.plugins.annotations.Parameter(property="headerSecondEnabled")
    public boolean headerSecondEnabled = true;
    @org.apache.maven.plugins.annotations.Parameter(property="tableOfContentsEnabled")
    public boolean tableOfContentsEnabled = true;
    @org.apache.maven.plugins.annotations.Parameter(property="outputPath")
    public String outputPath = "./doc";
    @org.apache.maven.plugins.annotations.Parameter(property="outputFile")
    public String outputFile = "index.adoc";
    @org.apache.maven.plugins.annotations.Parameter(property="outputJsonFile")
    public String outputJsonFile = "scheme.json";
    @org.apache.maven.plugins.annotations.Parameter(property="outputJsonFileEnabled")
    public Boolean outputJsonFileEnabled = false;
    @org.apache.maven.plugins.annotations.Parameter(property="outputJavaScriptFile")
    public String outputJavaScriptFile = "scheme.js";
    @org.apache.maven.plugins.annotations.Parameter(property="outputJavaScriptFileEnabled")
    public Boolean outputJavaScriptFileEnabled = false;
    @org.apache.maven.plugins.annotations.Parameter(property="outputYamlFile")
    public String outputYamlFile = "scheme.yaml";
    @org.apache.maven.plugins.annotations.Parameter(property="outputYamlFileEnabled")
    public Boolean outputYamlFileEnabled = false;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter(property="files")
    private List<String> files = new ArrayList<String>();
    @NonNull
    private final RootParser rootParser = new RootParser();
    @NonNull
    private final StringBuilder stringBuilder = new StringBuilder();

    @NonNull
    private ObjectMapper objectMapper(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull String name = file.toLowerCase(Locale.ROOT);
        if (name.endsWith(".json")) {
            return MapperUtil.json();
        }
        if (name.endsWith(".yaml")) {
            return MapperUtil.yaml();
        }
        if (name.endsWith(".yml")) {
            return MapperUtil.yaml();
        }
        throw new UnsupportedFormatException();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.header();
        @NonNull String json = this.rootParser.files(this.files).json();
        @NonNull Root root = (Root)MapperUtil.json().readValue(json, Root.class);
        this.generate(root);
        this.save();
    }

    @NonNull
    private Generator saveDatabaseYAML(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputYamlFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputYamlFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputYamlFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)this.rootParser.yaml());
        return this;
    }

    @NonNull
    private Generator saveDatabaseJSON(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputJsonFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputJsonFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputJsonFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)this.rootParser.json());
        return this;
    }

    @NonNull
    private Generator saveDatabaseJavaScript(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputJavaScriptFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputJavaScriptFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputJavaScriptFile);
        System.out.println(file);
        FileUtils.fileWrite((File)file, (String)("var scheme = " + this.rootParser.json()));
        return this;
    }

    public void save() {
        if (this.outputPath == null || this.outputPath.isEmpty()) {
            return;
        }
        if (this.outputFile == null || this.outputFile.isEmpty()) {
            return;
        }
        @NonNull File path = new File(this.outputPath);
        this.initOutputPath(path).saveDatabaseYAML(path).saveDatabaseJSON(path).saveDatabaseJavaScript(path);
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputFile);
        FileUtils.fileWrite((File)file, (String)this.stringBuilder.toString());
    }

    @NonNull
    private Generator initOutputPath(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        path.mkdirs();
        return this;
    }

    public void parse(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        @NonNull ObjectMapper objectMapper = this.objectMapper(file);
        @NonNull Root root = (Root)objectMapper.readValue(new File(file), Root.class);
        this.generate(root);
    }

    @NonNull
    public String generate(Root root) {
        if (root == null) {
            return "";
        }
        this.generate(root.getPaths());
        this.generate(root.getComponents());
        return this.stringBuilder.toString();
    }

    private void generate(Components components) {
        if (components == null) {
            return;
        }
        if (components.getSchemas() == null) {
            return;
        }
        if (components.getSchemas().isEmpty()) {
            return;
        }
        int index = 1;
        for (String model : components.getSchemas().keySet()) {
            this.generate(model, components.getSchemas().get(model), index);
            ++index;
        }
    }

    public void generate(String model, Schema schema, int indexm) {
        this.stringBuilder.append("=== \u041c\u043e\u0434\u0435\u043b\u044c \u0434\u0430\u043d\u043d\u044b\u0445 \"" + model + "\" [[" + model + "]]\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("==== \u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"20,80\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        this.stringBuilder.append("|" + StringUtil.format(model) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        this.stringBuilder.append("|" + StringUtil.format(schema.getDescription()) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*:\n");
        this.stringBuilder.append("|" + StringUtil.format(schema.getType()) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u0421\u0435\u0440\u0432\u0438\u0441*:\n");
        this.stringBuilder.append("|" + StringUtil.format(this.serviceName) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0435\u0439 \n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"0,30,30,20,10,10\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("^|*\u2116*\n");
        this.stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        this.stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        this.stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        this.stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        this.stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        this.stringBuilder.append("\n");
        boolean exists = true;
        Map<String, Schema> properties = schema.getProperties();
        if ("array".equalsIgnoreCase(schema.getType()) && schema.getItems() != null) {
            properties = schema.getItems().getProperties();
        }
        if (properties == null) {
            exists = false;
        }
        if (properties != null && properties.isEmpty()) {
            exists = false;
        }
        if (!exists) {
            this.stringBuilder.append("\n");
            this.stringBuilder.append("6+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            this.stringBuilder.append("\n");
        }
        if (exists) {
            int index = 1;
            for (String field : properties.keySet()) {
                Schema property = properties.get(field);
                this.stringBuilder.append("\n");
                this.stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
                this.stringBuilder.append("|" + StringUtil.format(field) + "\n");
                this.stringBuilder.append("|" + StringUtil.format(property.getDescription()) + "\n");
                this.stringBuilder.append("^| " + ContentUtil.scheme(property) + "\n");
                this.stringBuilder.append("^|" + ContentUtil.format(property) + "\n");
                if (schema.getRequired() == null) {
                    this.stringBuilder.append("^|--\n");
                } else if (schema.getRequired().contains(field)) {
                    this.stringBuilder.append("^|\u2713\n");
                } else {
                    this.stringBuilder.append("^|--\n");
                }
                ++index;
            }
        }
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
    }

    private void generate(Map<String, Map<String, Operation>> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (String path : paths.keySet()) {
            if (path == null || path.isEmpty()) continue;
            this.generate(path, paths.get(path));
        }
    }

    private void generate(String path, Map<String, Operation> operations) {
        if (path == null) {
            return;
        }
        for (String method : operations.keySet()) {
            if (method == null || method.isEmpty()) continue;
            this.generate(path, method, operations.get(method));
        }
    }

    private void generate(String path, String method, Operation operation) {
        if (path == null || path.isEmpty()) {
            return;
        }
        if (method == null || method.isEmpty()) {
            return;
        }
        if (operation == null) {
            return;
        }
        this.stringBuilder.append("=== \u0420\u0435\u0441\u0443\u0440\u0441 " + operation.tags() + " " + method.toUpperCase() + " \"" + path + "\" \n");
        this.stringBuilder.append("==== \u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"20,80\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        this.stringBuilder.append("|" + StringUtil.format(operation.getOperationId()) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        this.stringBuilder.append("|" + StringUtil.format(operation.getSummary()) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*\u0421\u0435\u0440\u0432\u0438\u0441*:\n");
        this.stringBuilder.append("|" + StringUtil.format(this.serviceName) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*HTTP-\u043c\u0435\u0442\u043e\u0434*:\n");
        this.stringBuilder.append("|" + StringUtil.format(method.toUpperCase()) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|*HTTP-\u0430\u0434\u0440\u0435\u0441*:\n");
        this.stringBuilder.append("|" + StringUtil.format(path) + "\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        if (operation.getParameters() == null) {
            operation.setParameters(Collections.emptyList());
        }
        this.generate(operation.getParameters().toArray(new Parameter[0]));
        this.stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"0,20,50,20,10\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("^|*\u2116*\n");
        this.stringBuilder.append("^|*\u041c\u0435\u0434\u0438\u0430 \u0442\u0438\u043f*\n");
        this.stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        this.stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        this.stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        this.stringBuilder.append("\n");
        boolean exists = true;
        if (operation.getRequestBody() == null) {
            exists = false;
        }
        if (operation.getRequestBody() != null) {
            if (operation.getRequestBody().getContent() == null) {
                exists = false;
            } else if (operation.getRequestBody().getContent().isEmpty()) {
                exists = false;
            }
        }
        if (!exists) {
            this.stringBuilder.append("\n");
            this.stringBuilder.append("5+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            this.stringBuilder.append("\n");
        }
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
            int index = 1;
            for (String mediaType : operation.getRequestBody().getContent().keySet()) {
                Content content = operation.getRequestBody().getContent().get(mediaType);
                if (content == null) continue;
                this.stringBuilder.append("\n");
                this.stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
                this.stringBuilder.append("^|" + StringUtil.format(mediaType) + "\n");
                this.stringBuilder.append("^| " + ContentUtil.scheme(content) + "\n");
                this.stringBuilder.append("^|" + ContentUtil.format(content) + "\n");
                this.stringBuilder.append("^|" + StringUtil.format(operation.getRequestBody().getRequired()) + "\n");
                this.stringBuilder.append("\n");
            }
        }
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.generate(operation);
    }

    private void generate(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"0,15,20,50,30,20\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("^|*\u2116*\n");
        this.stringBuilder.append("^|*HTTP-\u043a\u043e\u0434*\n");
        this.stringBuilder.append("^|*\u041c\u0435\u0434\u0438\u0430 \u0442\u0438\u043f*\n");
        this.stringBuilder.append("|*\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435*\n");
        this.stringBuilder.append("^|*\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445*\n");
        this.stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        this.stringBuilder.append("\n");
        if (operation.getResponses() == null) {
            operation.setResponses(Collections.emptyMap());
        }
        int index = 1;
        for (String httpCode : operation.getResponses().keySet()) {
            Response response = operation.getResponses().get(httpCode);
            if (response.getContent() == null || response.getContent().isEmpty()) continue;
            this.generate(httpCode, response, index);
            ++index;
        }
        if (index == 1) {
            this.stringBuilder.append("\n");
            this.stringBuilder.append("6+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            this.stringBuilder.append("\n");
        }
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
    }

    private void generate(@NonNull String httpCode, Response response, int index) {
        if (httpCode == null) {
            throw new NullPointerException("httpCode is marked non-null but is null");
        }
        if (response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        for (String mediaType : response.getContent().keySet()) {
            Content content = response.getContent().get(mediaType);
            this.stringBuilder.append("\n");
            this.stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
            this.stringBuilder.append("^|" + StringUtil.format(httpCode) + "\n");
            this.stringBuilder.append("^| \"" + StringUtil.format(mediaType) + "\" \n");
            this.stringBuilder.append("|" + String.format(response.getDescription(), new Object[0]) + "\n");
            this.stringBuilder.append("^| " + ContentUtil.scheme(content) + "\n");
            this.stringBuilder.append("^|" + ContentUtil.format(content) + "\n");
            this.stringBuilder.append("\n");
        }
    }

    private void generate(@NonNull Parameter[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.stringBuilder.append("==== \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \n");
        int index = 1;
        this.stringBuilder.append("\n");
        this.stringBuilder.append("[cols=\"0,20,20,10,10,10,10\"]\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
        this.stringBuilder.append("^|*\u2116*\n");
        this.stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        this.stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*\n");
        this.stringBuilder.append("^|*\u0422\u0438\u043f*\n");
        this.stringBuilder.append("^|*\u0424\u043e\u0440\u043c\u0430\u0442*\n");
        this.stringBuilder.append("^|*\u0412\u0438\u0434*\n");
        this.stringBuilder.append("^|*\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439*\n");
        this.stringBuilder.append("\n");
        if (parameters.length == 0) {
            this.stringBuilder.append("\n");
            this.stringBuilder.append("7+^| \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \n");
            this.stringBuilder.append("\n");
        }
        for (Parameter parameter : parameters) {
            this.generate(parameter, index);
            ++index;
        }
        this.stringBuilder.append("\n");
        this.stringBuilder.append("|===\n");
        this.stringBuilder.append("\n");
    }

    private void generate(Parameter parameter, int index) {
        this.stringBuilder.append("\n");
        this.stringBuilder.append("^|" + StringUtil.format(index) + ". \n");
        this.stringBuilder.append("|" + StringUtil.format(parameter.getName()) + "\n");
        this.stringBuilder.append("|" + StringUtil.format(parameter.getDescription()) + "\n");
        this.stringBuilder.append("^|" + parameter.getSchema().toString() + "\n");
        this.stringBuilder.append("^|" + ParameterUtil.format(parameter) + "\n");
        this.stringBuilder.append("^|" + StringUtil.format(parameter.getIn()) + "\n");
        this.stringBuilder.append("^|" + StringUtil.format(parameter.getRequired()) + "\n");
        this.stringBuilder.append("\n");
    }

    private void header() {
        if (this.headerFirstEnabled) {
            this.stringBuilder.append("= " + StringUtil.format(this.serviceName) + "\n");
            if (this.tableOfContentsEnabled) {
                this.stringBuilder.append(":toc-title: \u041e\u0433\u043b\u0430\u0432\u043b\u0435\u043d\u0438\u0435\n");
                this.stringBuilder.append(":toc:\n");
            }
            this.stringBuilder.append("\n");
        }
        if (this.headerSecondEnabled) {
            this.stringBuilder.append("== \u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0431-\u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \n");
            this.stringBuilder.append("\n");
        }
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public boolean isHeaderFirstEnabled() {
        return this.headerFirstEnabled;
    }

    @Generated
    public void setHeaderFirstEnabled(boolean headerFirstEnabled) {
        this.headerFirstEnabled = headerFirstEnabled;
    }

    @Generated
    public boolean isHeaderSecondEnabled() {
        return this.headerSecondEnabled;
    }

    @Generated
    public void setHeaderSecondEnabled(boolean headerSecondEnabled) {
        this.headerSecondEnabled = headerSecondEnabled;
    }

    @Generated
    public boolean isTableOfContentsEnabled() {
        return this.tableOfContentsEnabled;
    }

    @Generated
    public void setTableOfContentsEnabled(boolean tableOfContentsEnabled) {
        this.tableOfContentsEnabled = tableOfContentsEnabled;
    }

    @Generated
    public String getOutputPath() {
        return this.outputPath;
    }

    @Generated
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Generated
    public String getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Generated
    public String getOutputJsonFile() {
        return this.outputJsonFile;
    }

    @Generated
    public void setOutputJsonFile(String outputJsonFile) {
        this.outputJsonFile = outputJsonFile;
    }

    @Generated
    public Boolean getOutputJsonFileEnabled() {
        return this.outputJsonFileEnabled;
    }

    @Generated
    public void setOutputJsonFileEnabled(Boolean outputJsonFileEnabled) {
        this.outputJsonFileEnabled = outputJsonFileEnabled;
    }

    @Generated
    public String getOutputJavaScriptFile() {
        return this.outputJavaScriptFile;
    }

    @Generated
    public void setOutputJavaScriptFile(String outputJavaScriptFile) {
        this.outputJavaScriptFile = outputJavaScriptFile;
    }

    @Generated
    public Boolean getOutputJavaScriptFileEnabled() {
        return this.outputJavaScriptFileEnabled;
    }

    @Generated
    public void setOutputJavaScriptFileEnabled(Boolean outputJavaScriptFileEnabled) {
        this.outputJavaScriptFileEnabled = outputJavaScriptFileEnabled;
    }

    @Generated
    public String getOutputYamlFile() {
        return this.outputYamlFile;
    }

    @Generated
    public void setOutputYamlFile(String outputYamlFile) {
        this.outputYamlFile = outputYamlFile;
    }

    @Generated
    public Boolean getOutputYamlFileEnabled() {
        return this.outputYamlFileEnabled;
    }

    @Generated
    public void setOutputYamlFileEnabled(Boolean outputYamlFileEnabled) {
        this.outputYamlFileEnabled = outputYamlFileEnabled;
    }

    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(List<String> files) {
        this.files = files;
    }

    @NonNull
    @Generated
    public RootParser getRootParser() {
        return this.rootParser;
    }
}

