/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.openapidoc.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import ru.volnenko.plugin.openapidoc.util.StringUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Schema {
    private String description;
    private String type;
    private String format;
    @JsonProperty(value="$ref")
    private String reference;
    @JsonProperty(value="default")
    private String defaultValue;
    private Boolean uniqueItems;
    private Boolean writeOnly;
    private Boolean readOnly;
    private List<String> enums;
    private Object example;
    private Schema items;
    private Map<String, Schema> properties;
    private List<String> required;

    public boolean referenced() {
        String localReference = this.reference;
        String localType = this.type;
        if ("array".equalsIgnoreCase(this.type)) {
            if (this.items == null) {
                return false;
            }
            localReference = this.items.getReference();
            localType = this.items.getType();
        }
        return localReference != null && !localReference.isEmpty();
    }

    public String toString() {
        String localReference = this.reference;
        String localType = this.type;
        String dataType = "";
        if ("array".equalsIgnoreCase(this.type)) {
            if (this.items == null) {
                return "array";
            }
            localReference = this.items.getReference();
            localType = this.items.getType();
        }
        if (localReference != null && !localReference.isEmpty()) {
            String[] items = localReference.split("/");
            dataType = items[items.length - 1];
        } else {
            dataType = StringUtil.format(localType);
        }
        if (this.referenced()) {
            dataType = "<<" + dataType + "," + dataType + ">>";
        }
        if ("array".equalsIgnoreCase(this.type)) {
            dataType = dataType + "[]";
        }
        return dataType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Generated
    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    @Generated
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Generated
    public List<String> getEnums() {
        return this.enums;
    }

    @Generated
    public Object getExample() {
        return this.example;
    }

    @Generated
    public Schema getItems() {
        return this.items;
    }

    @Generated
    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    @Generated
    public List<String> getRequired() {
        return this.required;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="$ref")
    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @JsonProperty(value="default")
    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @Generated
    public void setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @Generated
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setEnums(List<String> enums) {
        this.enums = enums;
    }

    @Generated
    public void setExample(Object example) {
        this.example = example;
    }

    @Generated
    public void setItems(Schema items) {
        this.items = items;
    }

    @Generated
    public void setProperties(Map<String, Schema> properties) {
        this.properties = properties;
    }

    @Generated
    public void setRequired(List<String> required) {
        this.required = required;
    }

    @Generated
    public Schema() {
    }
}

