/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.wagon;

import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import lombok.NonNull;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import ru.volnenko.plugin.wagon.BaseWagon;
import ru.volnenko.plugin.wagon.DiskVisitor;

public class MinioWagon
extends BaseWagon {
    private MinioClient minioClient;

    public void fillInputData(InputData inputData) {
        try {
            inputData.setInputStream(this.minioClient.getObject(this.getMinioBucket(), this.getMinioPathname() + "/" + inputData.getResource().getName()));
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchKey")) {
                throw new ResourceDoesNotExistException(e.getMessage(), (Throwable)e);
            }
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public void fillOutputData(final OutputData outputData) {
        outputData.setOutputStream((OutputStream)new ByteArrayOutputStream(){

            @Override
            public void close() {
                @NonNull ByteArrayInputStream inputStream = new ByteArrayInputStream(this.toByteArray());
                @NonNull String resource = outputData.getResource().getName();
                @NonNull String objectName = MinioWagon.this.getMinioPathname() + "/" + resource;
                @NonNull String mimeType = URLConnection.guessContentTypeFromName(outputData.getResource().getName());
                MinioWagon.this.minioClient.putObject(MinioWagon.this.getMinioBucket(), objectName, (InputStream)inputStream, mimeType);
            }
        });
    }

    public void closeConnection() {
        this.minioClient = null;
    }

    protected void openConnectionInternal() {
        System.out.println("MINIO HOST NAME: " + this.getMinioHostname());
        System.out.println("MINIO BUCKET: " + this.getMinioBucket());
        this.minioClient = this.getMinioClient();
    }

    public void putDirectory(@NonNull File sourceDirectory, @NonNull String destinationDirectory) {
        if (sourceDirectory == null) {
            throw new NullPointerException("sourceDirectory is marked non-null but is null");
        }
        if (destinationDirectory == null) {
            throw new NullPointerException("destinationDirectory is marked non-null but is null");
        }
        @NonNull URI uri = sourceDirectory.getAbsoluteFile().toURI();
        @NonNull DiskVisitor diskVisitor = this.getDiskVisitor(sourceDirectory);
        Files.walkFileTree(Paths.get(uri), diskVisitor);
    }

    @NonNull
    private DiskVisitor getDiskVisitor(@NonNull File sourceDirectory) {
        if (sourceDirectory == null) {
            throw new NullPointerException("sourceDirectory is marked non-null but is null");
        }
        return new DiskVisitor(this.getMinioPathname(), sourceDirectory, this.minioClient, this.getMinioBucket());
    }

    @Override
    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }
}

