/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.wagon;

import io.minio.MinioClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.NonNull;

public final class DiskVisitor
extends SimpleFileVisitor<Path> {
    @NonNull
    private final String basedir;
    @NonNull
    private final File source;
    @NonNull
    private final MinioClient minioClient;
    @NonNull
    private final String bucket;

    public DiskVisitor(@NonNull String basedir, @NonNull File source, @NonNull MinioClient minioClient, @NonNull String bucket) {
        if (basedir == null) {
            throw new NullPointerException("basedir is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (minioClient == null) {
            throw new NullPointerException("minioClient is marked non-null but is null");
        }
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        this.basedir = basedir;
        this.source = source;
        this.minioClient = minioClient;
        this.bucket = bucket;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return FileVisitResult.CONTINUE;
        }
        @NonNull String relative = this.source.toURI().relativize(file.toUri()).toString();
        @NonNull String target = this.basedir + "/" + relative;
        System.out.println("UPLOAD: " + target);
        @NonNull byte[] bytes = Files.readAllBytes(file);
        @NonNull ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        @NonNull String mimeType = URLConnection.guessContentTypeFromName(file.toFile().getName());
        this.minioClient.putObject(this.bucket, target, (InputStream)inputStream, mimeType);
        return FileVisitResult.CONTINUE;
    }
}

