/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.plugin.wagon;

import io.minio.MinioClient;
import lombok.NonNull;
import org.apache.maven.wagon.StreamWagon;

public abstract class BaseWagon
extends StreamWagon {
    public boolean supportsDirectoryCopy() {
        return true;
    }

    @NonNull
    public String getBasedir() {
        String base = this.repository.getBasedir();
        if (base.endsWith("/")) {
            return base.substring(0, base.length() - 1);
        }
        return base;
    }

    @NonNull
    public String getMinioPathname() {
        @NonNull String bucket = this.getMinioBucket();
        int length = bucket.length();
        return this.repository.getBasedir().substring(length + 2);
    }

    @NonNull
    public String getMinioBucket() {
        return this.getBasedir().split("/")[1];
    }

    @NonNull
    public String getMinioHostname() {
        String host = System.getenv("MINIO_HOSTNAME");
        if (host == null && (host = System.getProperty("minio.hostname")) == null) {
            host = this.repository.getHost();
        }
        return host;
    }

    @NonNull
    public MinioClient getMinioClient() {
        return new MinioClient(this.getMinioBasedir(), this.getMinioUsername(), this.getMinioPassword());
    }

    @NonNull
    public String getMinioBasedir() {
        return this.getMinioProtocol() + "://" + this.getMinioHostname();
    }

    @NonNull
    public String getMinioProtocol() {
        return this.repository.getProtocol();
    }

    @NonNull
    public String getMinioUsername() {
        String user = System.getenv("MINIO_USERNAME");
        if (user == null && (user = System.getProperty("minio.user")) == null && (user = this.authenticationInfo.getUserName()) == null) {
            user = "minio";
        }
        return user;
    }

    @NonNull
    public String getMinioPassword() {
        String password = System.getenv("MINIO_PASSWORD");
        if (password == null && (password = System.getProperty("minio.password")) == null && (password = this.authenticationInfo.getPassword()) == null) {
            password = "minio123";
        }
        return password;
    }
}

