/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.model.impl.AddUniqueConstraint;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ColumnWrapper;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.model.impl.UK;

public final class UniqueKeyUtil {
    @NonNull
    public static Set<UK> uks(Collection<Root> roots) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<UK> result = new LinkedHashSet<UK>();
        for (Root root : roots) {
            result.addAll(UniqueKeyUtil.uks(root));
        }
        return result;
    }

    @NonNull
    public static Set<UK> uks(Root root) {
        if (root == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog() == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog().isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<UK> result = new LinkedHashSet<UK>();
        for (DatabaseChangeLog changeLog : root.getDatabaseChangeLog()) {
            List<Change> changes;
            ChangeSet changeSet;
            if (changeLog == null || (changeSet = changeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
            for (Change change : changes) {
                if (change == null) continue;
                result.addAll(UniqueKeyUtil.uk(change.getCreateTable()));
                UK uk = UniqueKeyUtil.uk(change.getAddUniqueConstraint());
                if (uk == null) continue;
                result.add(uk);
            }
        }
        return result;
    }

    public static boolean enabled(Column column) {
        if (column == null) {
            return false;
        }
        if (column.getConstraints() == null) {
            return false;
        }
        if (column.getConstraints().getUnique() == null) {
            return false;
        }
        return column.getConstraints().getUnique();
    }

    @NonNull
    public static Set<UK> uk(CreateTable createTable) {
        if (createTable == null) {
            return Collections.emptySet();
        }
        if (createTable.getColumns() == null) {
            return Collections.emptySet();
        }
        if (createTable.getColumns().isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<UK> result = new LinkedHashSet<UK>();
        for (ColumnWrapper columnWrapper : createTable.getColumns()) {
            UK uk;
            Column column;
            if (columnWrapper == null || (column = columnWrapper.getColumn()) == null || (uk = UniqueKeyUtil.uk(createTable.getTableName(), column)) == null) continue;
            result.add(uk);
        }
        return result;
    }

    public static UK uk(AddUniqueConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        if (constraint.getTableName() == null) {
            return null;
        }
        if (constraint.getTableName().isEmpty()) {
            return null;
        }
        if (constraint.getColumnNames() == null) {
            return null;
        }
        if (constraint.getColumnNames().isEmpty()) {
            return null;
        }
        UK uk = new UK();
        uk.setTableName(constraint.getTableName());
        uk.setFieldName(constraint.getColumnNames());
        return uk;
    }

    public static UK uk(String tableName, Column column) {
        if (column == null) {
            return null;
        }
        if (tableName == null || tableName.isEmpty()) {
            return null;
        }
        if (column.getConstraints() == null) {
            return null;
        }
        if (column.getConstraints().getUnique() == null) {
            return null;
        }
        if (!column.getConstraints().getUnique().booleanValue()) {
            return null;
        }
        @NonNull UK uk = new UK();
        uk.setTableName(tableName);
        uk.setFieldName(column.getName());
        return uk;
    }
}

