/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;

public final class TableUtil {
    @NonNull
    public static List<CreateTable> getCreateTablesWithoutDatabase(@NonNull Collection<Root> roots) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        @NonNull ArrayList<CreateTable> result = new ArrayList<CreateTable>();
        for (Root root : roots) {
            List<DatabaseChangeLog> databaseChangeLogs;
            if (root == null || (databaseChangeLogs = root.getDatabaseChangeLog()) == null || databaseChangeLogs.isEmpty()) continue;
            for (DatabaseChangeLog databaseChangeLog : databaseChangeLogs) {
                List<Change> changes;
                ChangeSet changeSet;
                if (databaseChangeLog == null || (changeSet = databaseChangeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
                for (Change change : changes) {
                    String catalogName;
                    CreateTable createTable;
                    if (change == null || (createTable = change.getCreateTable()) == null || (catalogName = createTable.getCatalogName()) != null && !catalogName.isEmpty()) continue;
                    result.add(createTable);
                }
            }
        }
        return result;
    }

    @NonNull
    public static List<CreateTable> getCreateTablesWithDatabase(@NonNull Collection<Root> roots, @NonNull String database) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        @NonNull ArrayList<CreateTable> result = new ArrayList<CreateTable>();
        for (Root root : roots) {
            List<DatabaseChangeLog> databaseChangeLogs;
            if (root == null || (databaseChangeLogs = root.getDatabaseChangeLog()) == null || databaseChangeLogs.isEmpty()) continue;
            for (DatabaseChangeLog databaseChangeLog : databaseChangeLogs) {
                List<Change> changes;
                ChangeSet changeSet;
                if (databaseChangeLog == null || (changeSet = databaseChangeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
                for (Change change : changes) {
                    String catalogName;
                    CreateTable createTable;
                    if (change == null || (createTable = change.getCreateTable()) == null || (catalogName = createTable.getCatalogName()) == null || catalogName.isEmpty() || !database.equals(catalogName)) continue;
                    result.add(createTable);
                }
            }
        }
        return result;
    }
}

