/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ColumnWrapper;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.PK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.util.ColumnUtil;

public final class PrimaryKeyUtil {
    @NonNull
    public static Set<PK> pks(Collection<Root> roots) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<PK> result = new LinkedHashSet<PK>();
        for (Root root : roots) {
            result.addAll(PrimaryKeyUtil.pks(root));
        }
        return result;
    }

    @NonNull
    public static Set<PK> pks(Root root) {
        if (root == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog() == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog().isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<PK> result = new LinkedHashSet<PK>();
        for (DatabaseChangeLog changeLog : root.getDatabaseChangeLog()) {
            List<Change> changes;
            ChangeSet changeSet;
            if (changeLog == null || (changeSet = changeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
            for (Change change : changes) {
                CreateTable createTable;
                if (change == null || (createTable = change.getCreateTable()) == null || createTable.getColumns() == null) continue;
                for (ColumnWrapper columnWrapper : createTable.getColumns()) {
                    String name;
                    Column column = columnWrapper.getColumn();
                    if (column == null || (name = ColumnUtil.getName(column)) == null || name.isEmpty() || column.getConstraints() == null || column.getConstraints().getPrimaryKey() == null || !column.getConstraints().getPrimaryKey().booleanValue()) continue;
                    result.add(new PK(createTable.getTableName(), name));
                }
            }
        }
        return result;
    }
}

