/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.InputStream;
import lombok.NonNull;

public final class MapperUtil {
    @NonNull
    private static final ObjectMapper JSON = new ObjectMapper();
    @NonNull
    private static final ObjectMapper YAML = new YAMLMapper();

    @NonNull
    public static ObjectMapper json() {
        return JSON;
    }

    @NonNull
    public static ObjectMapper yaml() {
        return YAML;
    }

    @NonNull
    public static <T> T parseJsonFromResource(@NonNull String fileName, @NonNull Class<T> clazz) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + fileName);
        }
        return (T)MapperUtil.json().readValue(inputStream, clazz);
    }
}

