/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.model.impl.AddForeignKeyConstraint;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ColumnWrapper;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Constraints;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.FK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.PK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.model.impl.UK;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;
import ru.volnenko.maven.plugin.databasedoc.util.UniqueKeyUtil;

public final class ForeignKeyUtil {
    @NonNull
    public static Set<FK> fks(Collection<Root> roots) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<FK> result = new LinkedHashSet<FK>();
        for (Root root : roots) {
            result.addAll(ForeignKeyUtil.fks(root));
        }
        @NonNull Set<UK> uks = UniqueKeyUtil.uks(roots);
        for (FK fk : result) {
            if (fk == null || !uks.contains(fk.toUK())) continue;
            fk.setUnique(true);
        }
        return result;
    }

    @NonNull
    public static Set<FK> fks(Root root) {
        if (root == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog() == null) {
            return Collections.emptySet();
        }
        if (root.getDatabaseChangeLog().isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<FK> result = new LinkedHashSet<FK>();
        for (DatabaseChangeLog changeLog : root.getDatabaseChangeLog()) {
            List<Change> changes;
            ChangeSet changeSet;
            if (changeLog == null || (changeSet = changeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
            for (Change change : changes) {
                if (change == null) continue;
                result.addAll(ForeignKeyUtil.fk(change.getCreateTable()));
                FK fk = ForeignKeyUtil.fk(change.getAddForeignKeyConstraint());
                if (fk == null) continue;
                result.add(fk);
            }
        }
        return result;
    }

    @NonNull
    public static Set<FK> fk(CreateTable createTable) {
        if (createTable == null) {
            return Collections.emptySet();
        }
        if (createTable.getColumns() == null) {
            return Collections.emptySet();
        }
        if (createTable.getColumns().isEmpty()) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<FK> result = new LinkedHashSet<FK>();
        for (ColumnWrapper columnWrapper : createTable.getColumns()) {
            FK fk;
            Column column;
            if (columnWrapper == null || (column = columnWrapper.getColumn()) == null || (fk = ForeignKeyUtil.fk(createTable.getTableName(), column)) == null) continue;
            result.add(fk);
        }
        return result;
    }

    public static FK fk(AddForeignKeyConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        if (constraint.getBaseColumnNames() == null) {
            return null;
        }
        if (constraint.getBaseTableName() == null) {
            return null;
        }
        if (constraint.getReferencedColumnNames() == null) {
            return null;
        }
        if (constraint.getReferencedTableName() == null) {
            return null;
        }
        @NonNull FK fk = new FK();
        fk.setTableName(constraint.getBaseTableName());
        fk.setFieldName(constraint.getBaseColumnNames());
        fk.getPk().setTableName(constraint.getReferencedTableName());
        fk.getPk().setFieldName(constraint.getReferencedColumnNames());
        return fk;
    }

    public static FK fk(String tableName, Column column) {
        if (column == null) {
            return null;
        }
        if (tableName == null || tableName.isEmpty()) {
            return null;
        }
        if (column.getConstraints() == null) {
            return null;
        }
        if (column.getConstraints().getForeignKey() == null) {
            return null;
        }
        if (column.getConstraints().getForeignKey().getReferencedTableName() == null) {
            return null;
        }
        if (column.getConstraints().getForeignKey().getReferencedTableName().isEmpty()) {
            return null;
        }
        if (column.getConstraints().getForeignKey().getReferencedColumnNames() == null) {
            return null;
        }
        if (column.getConstraints().getForeignKey().getReferencedColumnNames().isEmpty()) {
            return null;
        }
        if (column.getName() == null || column.getName().isEmpty()) {
            return null;
        }
        @NonNull PK pk = new PK();
        pk.setTableName(column.getConstraints().getForeignKey().getReferencedTableName());
        pk.setFieldName(column.getConstraints().getForeignKey().getReferencedColumnNames());
        @NonNull FK fk = new FK();
        fk.setTableName(tableName);
        fk.setFieldName(column.getName());
        if (column.getConstraints().getUnique() != null) {
            fk.setUnique(column.getConstraints().getUnique());
        }
        fk.setPk(pk);
        return fk;
    }

    public static boolean enabled(Column column) {
        if (column == null) {
            return false;
        }
        if (column.getConstraints() == null) {
            return false;
        }
        if (column.getConstraints().getForeignKey() == null) {
            return false;
        }
        @NonNull Constraints constraints = column.getConstraints();
        if (StringUtil.exists(constraints.getForeignKeyName())) {
            return true;
        }
        if (StringUtil.exists(column.getConstraints().getForeignKey().getReferencedColumnNames())) {
            return true;
        }
        return StringUtil.exists(column.getConstraints().getForeignKey().getReferencedTableName());
    }
}

