/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.util;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;

public final class DataBaseUtil {
    @NonNull
    public static Set<String> getDataBases(Collection<Root> roots) {
        if (roots == null) {
            return Collections.emptySet();
        }
        @NonNull LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Root root : roots) {
            List<DatabaseChangeLog> databaseChangeLogs;
            if (root == null || (databaseChangeLogs = root.getDatabaseChangeLog()) == null || databaseChangeLogs.isEmpty()) continue;
            for (DatabaseChangeLog databaseChangeLog : databaseChangeLogs) {
                List<Change> changes;
                ChangeSet changeSet;
                if (databaseChangeLog == null || (changeSet = databaseChangeLog.getChangeSet()) == null || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
                for (Change change : changes) {
                    String catalogName;
                    CreateTable createTable;
                    if (change == null || (createTable = change.getCreateTable()) == null || (catalogName = createTable.getCatalogName()) == null || catalogName.isEmpty()) continue;
                    result.add(catalogName);
                }
            }
        }
        return result;
    }
}

