/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ErdRender;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ErdType;
import ru.volnenko.maven.plugin.databasedoc.generator.IEntityRelationDiagramDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.EntityRelationDiagramColumnWrapperGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.FK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.PK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.util.DataBaseUtil;
import ru.volnenko.maven.plugin.databasedoc.util.ForeignKeyUtil;
import ru.volnenko.maven.plugin.databasedoc.util.PrimaryKeyUtil;
import ru.volnenko.maven.plugin.databasedoc.util.TableUtil;

public final class EntityRelationDiagramDocumentGenerator
extends AbstractGenerator
implements IEntityRelationDiagramDocumentGenerator {
    @NonNull
    private EntityRelationDiagramColumnWrapperGenerator columnWrapperGenerator = new EntityRelationDiagramColumnWrapperGenerator();
    @NonNull
    private List<Root> roots = Collections.emptyList();
    @NonNull
    private ErdType erdType = ErdType.PHYSIC;
    private boolean multiDatabase = false;
    @NonNull
    private ErdRender erdRender = ErdRender.INTERNAL;

    @Override
    @NonNull
    public EntityRelationDiagramDocumentGenerator multiDatabase(boolean multiDatabase) {
        this.multiDatabase = multiDatabase;
        return this;
    }

    @Override
    @NonNull
    public EntityRelationDiagramDocumentGenerator erdType(@NonNull ErdType erdType) {
        if (erdType == null) {
            throw new NullPointerException("erdType is marked non-null but is null");
        }
        this.erdType = erdType;
        return this;
    }

    @Override
    @NonNull
    public ErdType erdType() {
        return this.erdType;
    }

    @Override
    @NonNull
    public EntityRelationDiagramDocumentGenerator physic() {
        this.erdType = ErdType.PHYSIC;
        return this;
    }

    @Override
    @NonNull
    public EntityRelationDiagramDocumentGenerator logic() {
        this.erdType = ErdType.LOGIC;
        return this;
    }

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull Root root) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        List<DatabaseChangeLog> databaseChangeLog = root.getDatabaseChangeLog();
        if (databaseChangeLog == null) {
            return;
        }
        for (DatabaseChangeLog item : databaseChangeLog) {
            this.generate(stringBuilder, item);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, DatabaseChangeLog databaseChangeLog) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (databaseChangeLog == null) {
            return;
        }
        this.generate(stringBuilder, databaseChangeLog.getChangeSet());
    }

    private void generate(@NonNull StringBuilder stringBuilder, ChangeSet changeSet) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (changeSet == null) {
            return;
        }
        for (Change change : changeSet.getChanges()) {
            this.generate(stringBuilder, change);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, Change change) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (change == null) {
            return;
        }
        CreateTable createTable = change.getCreateTable();
        this.generate(stringBuilder, createTable);
    }

    private void generate(@NonNull StringBuilder stringBuilder, CreateTable createTable) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (createTable == null) {
            return;
        }
        this.columnWrapperGenerator.erdType(this.erdType).createTable(createTable).columnWrappers(createTable.getColumns()).append(stringBuilder);
    }

    @Override
    @NonNull
    public IEntityRelationDiagramDocumentGenerator roots(@NonNull List<Root> roots) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        this.roots = roots;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramDocumentGenerator internal() {
        this.erdRender = ErdRender.INTERNAL;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramDocumentGenerator external() {
        this.erdRender = ErdRender.EXTERNAL;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        @NonNull Set<PK> pks = PrimaryKeyUtil.pks(this.roots);
        @NonNull Set<FK> fks = ForeignKeyUtil.fks(this.roots);
        stringBuilder.append("@startuml \n");
        stringBuilder.append("left to right direction \n");
        if (this.erdRender.isInternal()) {
            stringBuilder.append("!pragma graphviz_dot jdot \n");
            stringBuilder.append("'!pragma layout smetana \n");
            for (Root root : this.roots) {
                this.generate(stringBuilder, root);
            }
        }
        if (this.erdRender.isExternal()) {
            stringBuilder.append("'!pragma graphviz_dot jdot \n");
            stringBuilder.append("!pragma layout smetana \n");
            if (this.multiDatabase) {
                @NonNull Set<String> databases = DataBaseUtil.getDataBases(this.roots);
                for (String database : databases) {
                    stringBuilder.append("package \"" + database + "\" { \n");
                    @NonNull List<CreateTable> createTables = TableUtil.getCreateTablesWithDatabase(this.roots, database);
                    for (CreateTable createTable : createTables) {
                        this.generate(stringBuilder, createTable);
                    }
                    stringBuilder.append("} \n");
                }
                for (CreateTable createTable : TableUtil.getCreateTablesWithoutDatabase(this.roots)) {
                    this.generate(stringBuilder, createTable);
                }
            } else {
                for (Root root : this.roots) {
                    this.generate(stringBuilder, root);
                }
            }
        }
        for (FK fK : fks) {
            if (fK == null || !pks.contains(fK.getPk())) continue;
            if (fK.getUnique().booleanValue()) {
                stringBuilder.append("\"" + fK.getTableName() + "\" ||--|| \"" + fK.getPk().getTableName() + "\"\n");
                continue;
            }
            stringBuilder.append("\"" + fK.getTableName() + "\" }--|| \"" + fK.getPk().getTableName() + "\"\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("@enduml");
        stringBuilder.append("\n");
        return stringBuilder;
    }
}

