/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ErdType;
import ru.volnenko.maven.plugin.databasedoc.generator.IEntityRelationDiagramColumnWrapperGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.EntityRelationDiagramColumnGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ColumnWrapper;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;

public final class EntityRelationDiagramColumnWrapperGenerator
extends AbstractGenerator
implements IEntityRelationDiagramColumnWrapperGenerator {
    @NonNull
    private final EntityRelationDiagramColumnGenerator entityRelationDiagramColumnGenerator = new EntityRelationDiagramColumnGenerator();
    @NonNull
    private CreateTable createTable = new CreateTable();
    @NonNull
    private List<ColumnWrapper> columnWrappers = Collections.emptyList();
    @NonNull
    private ErdType erdType = ErdType.PHYSIC;
    private static final Predicate<ColumnWrapper> PK_PREDICATE = new Predicate<ColumnWrapper>(){

        @Override
        public boolean test(ColumnWrapper columnWrapper) {
            if (columnWrapper == null) {
                return false;
            }
            if (columnWrapper.getColumn() == null) {
                return false;
            }
            if (columnWrapper.getColumn().getConstraints() == null) {
                return false;
            }
            if (columnWrapper.getColumn().getConstraints().getPrimaryKey() == null) {
                return false;
            }
            return columnWrapper.getColumn().getConstraints().getPrimaryKey();
        }
    };
    private static final Predicate<ColumnWrapper> NOT_PK_PREDICATE = new Predicate<ColumnWrapper>(){

        @Override
        public boolean test(ColumnWrapper columnWrapper) {
            if (columnWrapper == null) {
                return false;
            }
            if (columnWrapper.getColumn() == null) {
                return false;
            }
            if (columnWrapper.getColumn().getConstraints() == null) {
                return false;
            }
            if (columnWrapper.getColumn().getConstraints().getPrimaryKey() == null) {
                return false;
            }
            return columnWrapper.getColumn().getConstraints().getPrimaryKey() == false;
        }
    };

    @Override
    @NonNull
    public ErdType erdType() {
        return this.erdType;
    }

    @Override
    @NonNull
    public EntityRelationDiagramColumnWrapperGenerator erdType(@NonNull ErdType erdType) {
        if (erdType == null) {
            throw new NullPointerException("erdType is marked non-null but is null");
        }
        this.erdType = erdType;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramColumnWrapperGenerator createTable(@NonNull CreateTable createTable) {
        if (createTable == null) {
            throw new NullPointerException("createTable is marked non-null but is null");
        }
        this.createTable = createTable;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramColumnWrapperGenerator stringBuilder(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        this.stringBuilder = stringBuilder;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramColumnWrapperGenerator columnWrappers(@NonNull List<ColumnWrapper> columnWrappers) {
        if (columnWrappers == null) {
            throw new NullPointerException("columnWrappers is marked non-null but is null");
        }
        this.columnWrappers = columnWrappers;
        return this;
    }

    private boolean hasPK() {
        return this.columnWrappers.stream().anyMatch(PK_PREDICATE);
    }

    @NonNull
    private String tableName() {
        @NonNull String tableName = StringUtil.format(this.createTable.getTableName());
        if (this.erdType.isPhysic()) {
            return "\"" + tableName + "\"";
        }
        if (this.erdType.isLogic()) {
            String name = this.createTable.getRemarks();
            if (name == null || name.isEmpty()) {
                return "\"" + tableName + "\"";
            }
            return "\"" + name + "\" as " + tableName;
        }
        return "\"" + tableName + "\"";
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        Column column;
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("entity " + this.tableName() + " {");
        stringBuilder.append("\n");
        if (this.hasPK()) {
            for (ColumnWrapper columnWrapper : this.columnWrappers.stream().filter(PK_PREDICATE).collect(Collectors.toList())) {
                column = columnWrapper.getColumn();
                if (column == null) continue;
                this.entityRelationDiagramColumnGenerator.erdType(this.erdType).column(column).append(stringBuilder);
            }
            stringBuilder.append("---\n");
        }
        for (ColumnWrapper columnWrapper : this.columnWrappers.stream().filter(NOT_PK_PREDICATE).collect(Collectors.toList())) {
            column = columnWrapper.getColumn();
            if (column == null) continue;
            this.entityRelationDiagramColumnGenerator.erdType(this.erdType).column(columnWrapper.getColumn()).append(stringBuilder);
        }
        stringBuilder.append("}");
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        return stringBuilder;
    }
}

