/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ColumnType;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ErdType;
import ru.volnenko.maven.plugin.databasedoc.generator.IEntityRelationDiagramColumnGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;

public final class EntityRelationDiagramColumnGenerator
extends AbstractGenerator
implements IEntityRelationDiagramColumnGenerator {
    @NonNull
    private Column column = new Column();
    @NonNull
    private ErdType erdType = ErdType.PHYSIC;

    @NonNull
    public ErdType erdType() {
        return this.erdType;
    }

    @NonNull
    public EntityRelationDiagramColumnGenerator erdType(@NonNull ErdType erdType) {
        if (erdType == null) {
            throw new NullPointerException("erdType is marked non-null but is null");
        }
        this.erdType = erdType;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramColumnGenerator stringBuilder(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        this.stringBuilder = stringBuilder;
        return this;
    }

    @Override
    @NonNull
    public IEntityRelationDiagramColumnGenerator column(@NonNull Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("    ");
        if (this.column.getConstraints().getPrimaryKey().booleanValue()) {
            stringBuilder.append("*");
        }
        stringBuilder.append("\"" + this.getName() + "\"");
        stringBuilder.append(" : ");
        stringBuilder.append("\"" + this.getType() + "\"");
        stringBuilder.append("\n");
        return stringBuilder;
    }

    @NonNull
    private String getType() {
        String type = StringUtil.format(this.column.getType());
        if (this.erdType.isPhysic()) {
            return type;
        }
        if (this.erdType.isLogic()) {
            ColumnType columnType = ColumnType.typeOf(type);
            if (columnType == null) {
                return type;
            }
            return columnType.displayName();
        }
        return type;
    }

    @NonNull
    private String getName() {
        if (this.erdType.isPhysic()) {
            return StringUtil.format(this.column.getName());
        }
        if (this.erdType.isLogic() && this.column.getRemarks() != null && !this.column.getRemarks().isEmpty()) {
            return StringUtil.format(this.column.getRemarks());
        }
        return StringUtil.format(this.column.getName());
    }
}

