/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.generator.IDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;

public final class DocumentGenerator
extends AbstractGenerator
implements IDocumentGenerator {
    @NonNull
    private Boolean headerFirstEnabled = true;
    @NonNull
    private Boolean tableOfContentsEnabled = true;
    @NonNull
    private Boolean headerSecondEnabled = true;
    @NonNull
    private String serviceName = "";
    @NonNull
    private Boolean entityRelationDiagramEnabled = true;
    @NonNull
    private Boolean entityRelationDiagramInclude = true;
    @NonNull
    public boolean entityRelationDiagramPhysicEnabled = true;
    @NonNull
    public boolean entityRelationDiagramLogicEnabled = true;

    @Override
    @NonNull
    public IDocumentGenerator entityRelationDiagramPhysicEnabled(@NonNull Boolean entityRelationDiagramPhysicEnabled) {
        if (entityRelationDiagramPhysicEnabled == null) {
            throw new NullPointerException("entityRelationDiagramPhysicEnabled is marked non-null but is null");
        }
        this.entityRelationDiagramPhysicEnabled = entityRelationDiagramPhysicEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator entityRelationDiagramLogicEnabled(@NonNull Boolean entityRelationDiagramLogicEnabled) {
        if (entityRelationDiagramLogicEnabled == null) {
            throw new NullPointerException("entityRelationDiagramLogicEnabled is marked non-null but is null");
        }
        this.entityRelationDiagramLogicEnabled = entityRelationDiagramLogicEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator entityRelationDiagramEnabled(@NonNull Boolean entityRelationDiagramEnabled) {
        if (entityRelationDiagramEnabled == null) {
            throw new NullPointerException("entityRelationDiagramEnabled is marked non-null but is null");
        }
        this.entityRelationDiagramEnabled = entityRelationDiagramEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator entityRelationDiagramInclude(@NonNull Boolean entityRelationDiagramInclude) {
        if (entityRelationDiagramInclude == null) {
            throw new NullPointerException("entityRelationDiagramInclude is marked non-null but is null");
        }
        this.entityRelationDiagramInclude = entityRelationDiagramInclude;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator headerFirstEnabled(@NonNull Boolean headerFirstEnabled) {
        if (headerFirstEnabled == null) {
            throw new NullPointerException("headerFirstEnabled is marked non-null but is null");
        }
        this.headerFirstEnabled = headerFirstEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator tableOfContentsEnabled(@NonNull Boolean tableOfContentsEnabled) {
        if (tableOfContentsEnabled == null) {
            throw new NullPointerException("tableOfContentsEnabled is marked non-null but is null");
        }
        this.tableOfContentsEnabled = tableOfContentsEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator headerSecondEnabled(@NonNull Boolean headerSecondEnabled) {
        if (headerSecondEnabled == null) {
            throw new NullPointerException("headerSecondEnabled is marked non-null but is null");
        }
        this.headerSecondEnabled = headerSecondEnabled;
        return this;
    }

    @Override
    @NonNull
    public IDocumentGenerator serviceName(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (this.headerFirstEnabled.booleanValue()) {
            stringBuilder.append("= " + StringUtil.format(this.serviceName) + "\n");
            if (this.tableOfContentsEnabled.booleanValue()) {
                stringBuilder.append(":toc-title: \u041e\u0433\u043b\u0430\u0432\u043b\u0435\u043d\u0438\u0435\n");
                stringBuilder.append(":toc:\n");
            }
            stringBuilder.append("\n");
        }
        if (this.headerSecondEnabled.booleanValue()) {
            stringBuilder.append("== \u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445\n");
        }
        if (this.entityRelationDiagramEnabled.booleanValue() && this.entityRelationDiagramInclude.booleanValue()) {
            if (this.entityRelationDiagramLogicEnabled) {
                stringBuilder.append("\n");
                stringBuilder.append("=== \u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f ER-\u0434\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \n");
                stringBuilder.append("\n");
                stringBuilder.append("image::erd_logic.svg[] \n");
                stringBuilder.append("\n");
            }
            if (this.entityRelationDiagramPhysicEnabled) {
                stringBuilder.append("\n");
                stringBuilder.append("=== \u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0430\u044f ER-\u0434\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \n");
                stringBuilder.append("\n");
                stringBuilder.append("image::erd_physic.svg[] \n");
                stringBuilder.append("\n");
            }
        }
        return stringBuilder;
    }
}

