/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.generator.ICreateTypeDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.CreateTypeGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateType;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;

public final class CreateTypeDocumentGenerator
extends AbstractGenerator
implements ICreateTypeDocumentGenerator {
    @NonNull
    private final CreateTypeGenerator createTypeGenerator = new CreateTypeGenerator();
    @NonNull
    private List<Root> roots = Collections.emptyList();
    @NonNull
    private String serviceName = "";
    @NonNull
    private String dataBaseInfo = "";

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull Root root) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        List<DatabaseChangeLog> databaseChangeLog = root.getDatabaseChangeLog();
        if (databaseChangeLog == null) {
            return;
        }
        for (DatabaseChangeLog item : databaseChangeLog) {
            this.generate(stringBuilder, item);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, DatabaseChangeLog databaseChangeLog) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (databaseChangeLog == null) {
            return;
        }
        this.generate(stringBuilder, databaseChangeLog.getChangeSet());
    }

    private void generate(@NonNull StringBuilder stringBuilder, ChangeSet changeSet) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (changeSet == null) {
            return;
        }
        for (Change change : changeSet.getChanges()) {
            this.generate(stringBuilder, change);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, Change change) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (change == null) {
            return;
        }
        CreateType createType = change.getCreateType();
        if (createType == null) {
            return;
        }
        this.createTypeGenerator.dataBaseInfo(this.dataBaseInfo).serviceName(this.serviceName).createType(createType).append(stringBuilder);
    }

    @Override
    @NonNull
    public ICreateTypeDocumentGenerator serviceName(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public ICreateTypeDocumentGenerator dataBaseInfo(@NonNull String dataBaseInfo) {
        if (dataBaseInfo == null) {
            throw new NullPointerException("dataBaseInfo is marked non-null but is null");
        }
        this.dataBaseInfo = dataBaseInfo;
        return this;
    }

    @Override
    @NonNull
    public ICreateTypeDocumentGenerator roots(@NonNull List<Root> roots) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        this.roots = roots;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        for (Root root : this.roots) {
            this.generate(stringBuilder, root);
        }
        return stringBuilder;
    }
}

