/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.generator.ICreateTableGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;

public final class CreateTableGenerator
extends AbstractGenerator
implements ICreateTableGenerator {
    @NonNull
    private CreateTable createTable = new CreateTable();
    @NonNull
    private String serviceName = "";
    @NonNull
    private String dataBaseInfo = "";

    @Override
    @NonNull
    public ICreateTableGenerator createTable(@NonNull CreateTable createTable) {
        if (createTable == null) {
            throw new NullPointerException("createTable is marked non-null but is null");
        }
        this.createTable = createTable;
        return this;
    }

    @Override
    @NonNull
    public ICreateTableGenerator serviceName(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public ICreateTableGenerator dataBaseInfo(@NonNull String dataBaseInfo) {
        if (dataBaseInfo == null) {
            throw new NullPointerException("dataBaseInfo is marked non-null but is null");
        }
        this.dataBaseInfo = dataBaseInfo;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        String text;
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("=== \u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c \"" + StringUtil.format(this.createTable.getTableName()) + "\"\n");
        stringBuilder.append("\n");
        stringBuilder.append("==== \u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f\n");
        stringBuilder.append("\n");
        stringBuilder.append("[cols=\"20,80\"]\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u0424\u0438\u0437. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.createTable.getTableName()) + "\n");
        stringBuilder.append("\n");
        stringBuilder.append("|*\u041b\u043e\u0433. \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435*:\n");
        stringBuilder.append("|" + StringUtil.format(this.createTable.getRemarks()) + "\n");
        @NonNull String name = StringUtil.format(this.serviceName);
        if (!name.isEmpty()) {
            stringBuilder.append("\n");
            stringBuilder.append("|*\u0421\u0435\u0440\u0432\u0438\u0441*:\n");
            stringBuilder.append("|" + name + "\n");
        }
        if (!(name = StringUtil.format(this.createTable.getCatalogName())).isEmpty()) {
            stringBuilder.append("\n");
            stringBuilder.append("|*\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445*:\n");
            stringBuilder.append("|" + name + "\n");
        }
        if (!(text = StringUtil.format(this.dataBaseInfo)).isEmpty()) {
            stringBuilder.append("\n");
            stringBuilder.append("|*\u0414\u043e\u043f. \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f*:\n");
            stringBuilder.append("|" + text + "\n");
        }
        if (!(name = StringUtil.format(this.createTable.getSchemaName())).isEmpty()) {
            stringBuilder.append("\n");
            stringBuilder.append("|*\u0421\u0445\u0435\u043c\u0430*:\n");
            stringBuilder.append("|" + name + "\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("|===\n");
        stringBuilder.append("\n");
        return stringBuilder;
    }
}

