/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.generator.ICreateTableDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.ColumnWrapperGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.CreateTableGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Change;
import ru.volnenko.maven.plugin.databasedoc.model.impl.ChangeSet;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateTable;
import ru.volnenko.maven.plugin.databasedoc.model.impl.DatabaseChangeLog;
import ru.volnenko.maven.plugin.databasedoc.model.impl.FK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.model.impl.UK;
import ru.volnenko.maven.plugin.databasedoc.util.ForeignKeyUtil;
import ru.volnenko.maven.plugin.databasedoc.util.UniqueKeyUtil;

public final class CreateTableDocumentGenerator
extends AbstractGenerator
implements ICreateTableDocumentGenerator {
    @NonNull
    private final ColumnWrapperGenerator columnWrapperGenerator = new ColumnWrapperGenerator();
    @NonNull
    private final CreateTableGenerator createTableGenerator = new CreateTableGenerator();
    @NonNull
    private List<Root> roots = Collections.emptyList();
    @NonNull
    private String serviceName = "";
    @NonNull
    private String dataBaseInfo = "";
    @NonNull
    private Set<FK> fks = Collections.emptySet();
    @NonNull
    private Set<UK> uks = Collections.emptySet();

    private void generate(@NonNull StringBuilder stringBuilder, @NonNull Root root) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        List<DatabaseChangeLog> databaseChangeLog = root.getDatabaseChangeLog();
        if (databaseChangeLog == null) {
            return;
        }
        for (DatabaseChangeLog item : databaseChangeLog) {
            this.generate(stringBuilder, item);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, DatabaseChangeLog databaseChangeLog) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (databaseChangeLog == null) {
            return;
        }
        this.generate(stringBuilder, databaseChangeLog.getChangeSet());
    }

    private void generate(@NonNull StringBuilder stringBuilder, ChangeSet changeSet) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (changeSet == null) {
            return;
        }
        for (Change change : changeSet.getChanges()) {
            this.generate(stringBuilder, change);
        }
    }

    private void generate(@NonNull StringBuilder stringBuilder, Change change) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (change == null) {
            return;
        }
        CreateTable createTable = change.getCreateTable();
        if (createTable == null) {
            return;
        }
        this.createTableGenerator.dataBaseInfo(this.dataBaseInfo).serviceName(this.serviceName).createTable(createTable).append(stringBuilder);
        this.columnWrapperGenerator.fks(this.fks).uks(this.uks).tableName(createTable.getTableName()).columnWrappers(createTable.getColumns()).append(stringBuilder);
    }

    @Override
    @NonNull
    public CreateTableDocumentGenerator dataBaseInfo(@NonNull String dataBaseInfo) {
        if (dataBaseInfo == null) {
            throw new NullPointerException("dataBaseInfo is marked non-null but is null");
        }
        this.dataBaseInfo = dataBaseInfo;
        return this;
    }

    @Override
    @NonNull
    public CreateTableDocumentGenerator serviceName(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.serviceName = serviceName;
        return this;
    }

    @Override
    @NonNull
    public CreateTableDocumentGenerator roots(@NonNull List<Root> roots) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        this.roots = roots;
        this.fks = ForeignKeyUtil.fks(roots);
        this.uks = UniqueKeyUtil.uks(roots);
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        for (Root root : this.roots) {
            this.generate(stringBuilder, root);
        }
        return stringBuilder;
    }
}

