/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.generator.impl;

import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.generator.IColumnGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.AbstractGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Column;
import ru.volnenko.maven.plugin.databasedoc.model.impl.FK;
import ru.volnenko.maven.plugin.databasedoc.model.impl.UK;
import ru.volnenko.maven.plugin.databasedoc.util.ConstraintUtil;
import ru.volnenko.maven.plugin.databasedoc.util.ForeignKeyUtil;
import ru.volnenko.maven.plugin.databasedoc.util.StringUtil;
import ru.volnenko.maven.plugin.databasedoc.util.UniqueKeyUtil;

public final class ColumnGenerator
extends AbstractGenerator
implements IColumnGenerator {
    @NonNull
    private Integer index = 1;
    @NonNull
    private Column column = new Column();
    @NonNull
    private String tableName = "";
    @NonNull
    private Set<FK> fks = Collections.emptySet();
    @NonNull
    private Set<UK> uks = Collections.emptySet();

    @NonNull
    public static IColumnGenerator create() {
        return new ColumnGenerator();
    }

    @Override
    @NonNull
    public IColumnGenerator tableName(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    @NonNull
    public IColumnGenerator fks(@NonNull Set<FK> fks) {
        if (fks == null) {
            throw new NullPointerException("fks is marked non-null but is null");
        }
        this.fks = fks;
        return this;
    }

    @Override
    @NonNull
    public IColumnGenerator uks(@NonNull Set<UK> uks) {
        if (uks == null) {
            throw new NullPointerException("uks is marked non-null but is null");
        }
        this.uks = uks;
        return this;
    }

    @Override
    @NonNull
    public IColumnGenerator stringBuilder(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        this.stringBuilder = stringBuilder;
        return this;
    }

    @Override
    @NonNull
    public ColumnGenerator index(@NonNull Integer index) {
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        this.index = index;
        return this;
    }

    @Override
    @NonNull
    public ColumnGenerator column(@NonNull Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
        return this;
    }

    @Override
    @NonNull
    public StringBuilder append(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        stringBuilder.append("\n");
        stringBuilder.append("^|" + StringUtil.format(this.index) + ". \n");
        stringBuilder.append("|" + StringUtil.format(this.column.getName()) + "\n");
        stringBuilder.append("|" + StringUtil.format(this.column.getType()) + "\n");
        stringBuilder.append("|" + StringUtil.format(this.column.getRemarks()) + "\n");
        stringBuilder.append("^|" + StringUtil.format(this.column.getConstraints().getPrimaryKey()) + "\n");
        boolean uke = UniqueKeyUtil.enabled(this.column);
        if (!uke) {
            UK uk = new UK(this.tableName, this.column.getName());
            uke = this.uks.contains(uk);
        }
        stringBuilder.append("^|" + StringUtil.format(uke) + "\n");
        boolean fke = ForeignKeyUtil.enabled(this.column);
        if (!fke) {
            FK fk = new FK(this.tableName, this.column.getName());
            fke = this.fks.contains(fk);
        }
        stringBuilder.append("^|" + StringUtil.format(fke) + "\n");
        stringBuilder.append("^|" + StringUtil.format(this.column.getAutoIncrement()) + "\n");
        stringBuilder.append("^|" + StringUtil.format(ConstraintUtil.notnull(this.column)) + "\n");
        stringBuilder.append("|" + StringUtil.format(this.column.getDefaultValue()) + "\n");
        stringBuilder.append("\n");
        return stringBuilder;
    }
}

