/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.enumerated;

import java.util.Locale;
import lombok.NonNull;

public enum ColumnType {
    ARRAY("\u041c\u0430\u0441\u0441\u0438\u0432", "[]", "array"),
    INTEGER("\u0426\u0435\u043b\u043e\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0439", "int", "serial", "byte", "bit", "uuid", "long", "number", "year", "month", "day", "hour", "minute", "second"),
    BINARY("\u0411\u0438\u043d\u0430\u0440\u043d\u044b\u0439", "raw", "binary", "blob"),
    FLOAT("\u0414\u0440\u043e\u0431\u043d\u044b\u0439", "float", "double", "real", "precision", "numeric"),
    DATETIME("\u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f", "date", "time", "interval"),
    BOOLEAN("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439", "bool", "boolean"),
    STRING("\u0421\u0442\u0440\u043e\u043a\u0430", "varchar", "text", "json", "clob", "char", "string", "jsonb");

    @NonNull
    private final String displayName;
    @NonNull
    private final String[] parts;

    private ColumnType(String displayName, String ... parts) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (parts == null) {
            throw new NullPointerException("parts is marked non-null but is null");
        }
        this.displayName = displayName;
        this.parts = parts;
    }

    private static boolean check(ColumnType columnType, String type) {
        for (String part : columnType.parts) {
            String partLower = part.toLowerCase(Locale.ROOT);
            String typeLower = type.toLowerCase(Locale.ROOT);
            if (!typeLower.contains(partLower)) continue;
            return true;
        }
        return false;
    }

    public static ColumnType typeOf(String type) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        for (ColumnType columnType : ColumnType.values()) {
            if (!ColumnType.check(columnType, type)) continue;
            return columnType;
        }
        return null;
    }

    @NonNull
    public String displayName() {
        return this.displayName;
    }
}

