/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc.builder.impl;

import lombok.NonNull;
import ru.volnenko.maven.plugin.databasedoc.builder.ICreateTypeBuilder;
import ru.volnenko.maven.plugin.databasedoc.builder.impl.ChangeBuilder;
import ru.volnenko.maven.plugin.databasedoc.builder.impl.ValueBuilder;
import ru.volnenko.maven.plugin.databasedoc.model.impl.CreateType;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;

public final class CreateTypeBuilder
implements ICreateTypeBuilder {
    @NonNull
    private final ChangeBuilder changeBuilder;
    @NonNull
    private final CreateType createType = new CreateType();

    public CreateTypeBuilder(@NonNull ChangeBuilder changeBuilder) {
        if (changeBuilder == null) {
            throw new NullPointerException("changeBuilder is marked non-null but is null");
        }
        this.changeBuilder = changeBuilder;
        changeBuilder.change().setCreateType(this.createType);
    }

    @Override
    @NonNull
    public CreateTypeBuilder catalogName(String catalogName) {
        this.createType.setCatalogName(catalogName);
        return this;
    }

    @Override
    @NonNull
    public CreateTypeBuilder tablespace(String tablespace) {
        this.createType.setTablespace(tablespace);
        return this;
    }

    @Override
    @NonNull
    public CreateTypeBuilder typeName(String typeName) {
        this.createType.setTypeName(typeName);
        return this;
    }

    @Override
    @NonNull
    public CreateTypeBuilder remarks(String remarks) {
        this.createType.setRemarks(remarks);
        return this;
    }

    @Override
    @NonNull
    public Root root() {
        return this.changeBuilder.root();
    }

    @Override
    @NonNull
    public ChangeBuilder change() {
        return this.changeBuilder.and();
    }

    @Override
    @NonNull
    public CreateType createType() {
        return this.createType;
    }

    @NonNull
    public ValueBuilder value() {
        return new ValueBuilder(this);
    }
}

