/*
 * Decompiled with CFR 0.152.
 */
package ru.volnenko.maven.plugin.databasedoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import ru.volnenko.maven.plugin.databasedoc.enumerated.ErdType;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.CreateTableDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.CreateTypeDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.DocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.generator.impl.EntityRelationDiagramDocumentGenerator;
import ru.volnenko.maven.plugin.databasedoc.model.impl.Root;
import ru.volnenko.maven.plugin.databasedoc.parser.RootParser;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public final class Generator
extends AbstractMojo {
    @Parameter(property="serviceName")
    public String serviceName = "\u0421\u0435\u0440\u0432\u0438\u0441";
    @Parameter(property="dataBaseInfo")
    public String dataBaseInfo = "";
    @Parameter(property="headerFirstEnabled")
    public boolean headerFirstEnabled = true;
    @Parameter(property="headerSecondEnabled")
    public boolean headerSecondEnabled = true;
    @Parameter(property="tableOfContentsEnabled")
    public boolean tableOfContentsEnabled = true;
    @Parameter(property="tableOfContentsEnabled")
    public boolean entityRelationDiagramEnabled = true;
    @Parameter(property="entityRelationDiagramPhysicEnabled")
    public boolean entityRelationDiagramPhysicEnabled = true;
    @Parameter(property="entityRelationDiagramLogicEnabled")
    public boolean entityRelationDiagramLogicEnabled = true;
    @Parameter(property="entityRelationDiagramInclude")
    public boolean entityRelationDiagramInclude = true;
    @Parameter(property="entityRelationDiagramInclude")
    public boolean entityRelationDiagramMultiDatabase = false;
    @Parameter(property="outputPath")
    public String outputPath = "./doc";
    @Parameter(property="outputJsonFile")
    public String outputJsonFile = "scheme.json";
    @Parameter(property="outputJsonFileEnabled")
    public Boolean outputJsonFileEnabled = false;
    @Parameter(property="outputYamlFile")
    public String outputYamlFile = "scheme.yaml";
    @Parameter(property="outputYamlFileEnabled")
    public Boolean outputYamlFileEnabled = false;
    @Parameter(property="outputFile")
    public String outputFile = "index.adoc";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="files")
    private List<String> files = new ArrayList<String>();
    @NonNull
    private final StringBuilder stringBuilder = new StringBuilder();
    @NonNull
    private final DocumentGenerator documentGenerator = new DocumentGenerator();
    @NonNull
    private EntityRelationDiagramDocumentGenerator entityRelationDiagramDocumentGenerator = new EntityRelationDiagramDocumentGenerator();
    @NonNull
    private CreateTypeDocumentGenerator createTypeDocumentGenerator = new CreateTypeDocumentGenerator();
    @NonNull
    private CreateTableDocumentGenerator createTableDocumentGenerator = new CreateTableDocumentGenerator();
    @NonNull
    private final RootParser rootParser = new RootParser();

    public void execute() {
        this.documentGenerator.serviceName(this.serviceName).entityRelationDiagramEnabled(this.entityRelationDiagramEnabled).entityRelationDiagramInclude(this.entityRelationDiagramInclude).headerSecondEnabled(this.headerSecondEnabled).headerFirstEnabled(this.headerFirstEnabled).tableOfContentsEnabled(this.tableOfContentsEnabled).append(this.stringBuilder);
        @NonNull List<Root> roots = this.rootParser.files(this.files).parse();
        this.createTableDocumentGenerator.serviceName(this.serviceName).dataBaseInfo(this.dataBaseInfo).roots(roots).append(this.stringBuilder);
        this.createTypeDocumentGenerator.serviceName(this.serviceName).dataBaseInfo(this.dataBaseInfo).roots(roots).append(this.stringBuilder);
        this.save(roots);
    }

    public void save(@NonNull List<Root> roots) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        if (this.outputPath == null || this.outputPath.isEmpty()) {
            return;
        }
        if (this.outputFile == null || this.outputFile.isEmpty()) {
            return;
        }
        @NonNull File path = new File(this.outputPath);
        this.initOutputPath(path).saveDatabaseYAML(path).saveDatabaseJSON(path).saveEntityRelationDiagramLogic(roots, path).saveEntityRelationDiagramPhysic(roots, path).saveEntityRelationDiagramADOC(path);
    }

    @NonNull
    private Generator saveEntityRelationDiagramPhysic(@NonNull List<Root> roots, @NonNull File path) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.entityRelationDiagramEnabled) {
            return this;
        }
        if (!this.entityRelationDiagramPhysicEnabled) {
            return this;
        }
        return this.saveEntityRelationDiagram(roots, path, ErdType.PHYSIC, "erd_physic");
    }

    @NonNull
    private Generator saveEntityRelationDiagramLogic(@NonNull List<Root> roots, @NonNull File path) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.entityRelationDiagramEnabled) {
            return this;
        }
        if (!this.entityRelationDiagramLogicEnabled) {
            return this;
        }
        return this.saveEntityRelationDiagram(roots, path, ErdType.LOGIC, "erd_logic");
    }

    @NonNull
    private Generator saveEntityRelationDiagram(@NonNull List<Root> roots, @NonNull File path, @NonNull ErdType erdType, @NonNull String filename) {
        if (roots == null) {
            throw new NullPointerException("roots is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (erdType == null) {
            throw new NullPointerException("erdType is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        @NonNull StringBuilder erdInternal = this.entityRelationDiagramDocumentGenerator.erdType(erdType).multiDatabase(this.entityRelationDiagramMultiDatabase).internal().roots(roots).append(new StringBuilder());
        @NonNull StringBuilder erdExternal = this.entityRelationDiagramDocumentGenerator.erdType(erdType).multiDatabase(this.entityRelationDiagramMultiDatabase).external().roots(roots).append(new StringBuilder());
        return this.saveEntityRelationDiagramPUML(path, erdInternal, filename).saveEntityRelationDiagramSVG(path, erdInternal, filename).saveEntityRelationDiagramPUML(path, erdExternal, filename);
    }

    @NonNull
    private Generator initOutputPath(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        path.mkdirs();
        return this;
    }

    @NonNull
    private Generator saveEntityRelationDiagramADOC(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.outputFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputFile);
        FileUtils.fileWrite((File)file, (String)this.stringBuilder.toString());
        return this;
    }

    @NonNull
    private Generator saveDatabaseYAML(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputYamlFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputYamlFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputYamlFile);
        FileUtils.fileWrite((File)file, (String)this.rootParser.yaml());
        return this;
    }

    @NonNull
    private Generator saveDatabaseJSON(@NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.outputJsonFileEnabled.booleanValue()) {
            return this;
        }
        if (this.outputJsonFile.isEmpty()) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + this.outputJsonFile);
        FileUtils.fileWrite((File)file, (String)this.rootParser.json());
        return this;
    }

    @NonNull
    private Generator saveEntityRelationDiagramPUML(@NonNull File path, @NonNull StringBuilder stringBuilder, @NonNull String filename) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (!this.entityRelationDiagramEnabled) {
            return this;
        }
        @NonNull File file = new File(path.getAbsolutePath() + "/" + filename + ".puml");
        FileUtils.fileWrite((File)file, (String)stringBuilder.toString());
        return this;
    }

    @NonNull
    private Generator saveEntityRelationDiagramSVG(@NonNull File path, @NonNull StringBuilder stringBuilder, @NonNull String filename) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (!this.entityRelationDiagramEnabled) {
            return this;
        }
        @NonNull SourceStringReader reader = new SourceStringReader(stringBuilder.toString());
        @NonNull FileOutputStream output = new FileOutputStream(new File(path.getAbsolutePath() + "/" + filename + ".svg"));
        reader.generateImage((OutputStream)output, new FileFormatOption(FileFormat.SVG, false));
        return this;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getDataBaseInfo() {
        return this.dataBaseInfo;
    }

    @Generated
    public void setDataBaseInfo(String dataBaseInfo) {
        this.dataBaseInfo = dataBaseInfo;
    }

    @Generated
    public boolean isHeaderFirstEnabled() {
        return this.headerFirstEnabled;
    }

    @Generated
    public void setHeaderFirstEnabled(boolean headerFirstEnabled) {
        this.headerFirstEnabled = headerFirstEnabled;
    }

    @Generated
    public boolean isHeaderSecondEnabled() {
        return this.headerSecondEnabled;
    }

    @Generated
    public void setHeaderSecondEnabled(boolean headerSecondEnabled) {
        this.headerSecondEnabled = headerSecondEnabled;
    }

    @Generated
    public boolean isTableOfContentsEnabled() {
        return this.tableOfContentsEnabled;
    }

    @Generated
    public void setTableOfContentsEnabled(boolean tableOfContentsEnabled) {
        this.tableOfContentsEnabled = tableOfContentsEnabled;
    }

    @Generated
    public boolean isEntityRelationDiagramEnabled() {
        return this.entityRelationDiagramEnabled;
    }

    @Generated
    public void setEntityRelationDiagramEnabled(boolean entityRelationDiagramEnabled) {
        this.entityRelationDiagramEnabled = entityRelationDiagramEnabled;
    }

    @Generated
    public boolean isEntityRelationDiagramPhysicEnabled() {
        return this.entityRelationDiagramPhysicEnabled;
    }

    @Generated
    public void setEntityRelationDiagramPhysicEnabled(boolean entityRelationDiagramPhysicEnabled) {
        this.entityRelationDiagramPhysicEnabled = entityRelationDiagramPhysicEnabled;
    }

    @Generated
    public boolean isEntityRelationDiagramLogicEnabled() {
        return this.entityRelationDiagramLogicEnabled;
    }

    @Generated
    public void setEntityRelationDiagramLogicEnabled(boolean entityRelationDiagramLogicEnabled) {
        this.entityRelationDiagramLogicEnabled = entityRelationDiagramLogicEnabled;
    }

    @Generated
    public boolean isEntityRelationDiagramInclude() {
        return this.entityRelationDiagramInclude;
    }

    @Generated
    public void setEntityRelationDiagramInclude(boolean entityRelationDiagramInclude) {
        this.entityRelationDiagramInclude = entityRelationDiagramInclude;
    }

    @Generated
    public boolean isEntityRelationDiagramMultiDatabase() {
        return this.entityRelationDiagramMultiDatabase;
    }

    @Generated
    public void setEntityRelationDiagramMultiDatabase(boolean entityRelationDiagramMultiDatabase) {
        this.entityRelationDiagramMultiDatabase = entityRelationDiagramMultiDatabase;
    }

    @Generated
    public String getOutputPath() {
        return this.outputPath;
    }

    @Generated
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Generated
    public String getOutputJsonFile() {
        return this.outputJsonFile;
    }

    @Generated
    public void setOutputJsonFile(String outputJsonFile) {
        this.outputJsonFile = outputJsonFile;
    }

    @Generated
    public Boolean getOutputJsonFileEnabled() {
        return this.outputJsonFileEnabled;
    }

    @Generated
    public void setOutputJsonFileEnabled(Boolean outputJsonFileEnabled) {
        this.outputJsonFileEnabled = outputJsonFileEnabled;
    }

    @Generated
    public String getOutputYamlFile() {
        return this.outputYamlFile;
    }

    @Generated
    public void setOutputYamlFile(String outputYamlFile) {
        this.outputYamlFile = outputYamlFile;
    }

    @Generated
    public Boolean getOutputYamlFileEnabled() {
        return this.outputYamlFileEnabled;
    }

    @Generated
    public void setOutputYamlFileEnabled(Boolean outputYamlFileEnabled) {
        this.outputYamlFileEnabled = outputYamlFileEnabled;
    }

    @Generated
    public String getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(List<String> files) {
        this.files = files;
    }
}

